/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.EquipmentModifier;
import pcgen.core.SpecialProperty;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class EquipmentModifierLoader {
    private EquipmentModifierLoader() {
    }

    public static void parseLine(EquipmentModifier obj, String inputLine, URL sourceURL, int lineNum) throws PersistenceLayerException {
        if (obj == null) {
            return;
        }
        StringTokenizer colToken = new StringTokenizer(inputLine, "\t");
        int col = -1;
        if (!obj.isNewItem()) {
            col = 1;
            colToken.nextToken();
        }
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (PObjectLoader.parseTag(obj, colString)) continue;
            if (++col == 0) {
                obj.setName(colString.replace('|', ' '));
                continue;
            }
            if (colString.startsWith("ADDPROF:")) {
                obj.setProficiency(colString.substring(8));
                continue;
            }
            if (colString.startsWith("ARMORTYPE:")) {
                obj.setArmorType(colString.substring(10));
                continue;
            }
            if (colString.startsWith("ASSIGNTOALL:")) {
                obj.setAssignment(colString.substring(12));
                continue;
            }
            if (colString.startsWith("BONUS:")) {
                obj.addBonusList(colString.substring(6));
                continue;
            }
            if (colString.startsWith("CHARGES:")) {
                obj.setChargeInfo(colString.substring(8));
                continue;
            }
            if (colString.startsWith("COST:")) {
                obj.setCost(colString.substring(5));
                continue;
            }
            if (colString.startsWith("COSTPRE:")) {
                obj.setPreCost(colString.substring(8));
                continue;
            }
            if (colString.startsWith("COSTDOUBLE:")) {
                obj.setCostDouble(colString.substring(11).toUpperCase().startsWith("Y"));
                continue;
            }
            if (colString.startsWith("IGNORES:")) {
                obj.setIgnores(colString.substring(8));
                continue;
            }
            if (colString.startsWith("ITYPE:")) {
                obj.setItemType(colString.substring(6));
                continue;
            }
            if (colString.startsWith("NAMEOPT:")) {
                obj.setNamingOption(colString.substring(8));
                continue;
            }
            if (colString.startsWith("PLUS:")) {
                obj.setPlus(colString.substring(5));
                continue;
            }
            if (colString.startsWith("REPLACES:")) {
                obj.setReplacement(colString.substring(9));
                continue;
            }
            if (colString.startsWith("SPROP:")) {
                obj.addSpecialProperty(SpecialProperty.createFromLst(colString.substring(6)));
                continue;
            }
            if (colString.startsWith("VISIBLE:")) {
                obj.setVisible(colString.substring(8).toUpperCase());
                continue;
            }
            Logging.errorPrint("Illegal equipment modifier info " + sourceURL.toString() + ":" + Integer.toString(lineNum) + " \"" + colString + "\"");
        }
    }
}

