/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.StringTokenizer;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Delta;
import pcgen.util.Logging;

public final class FeatLoader
extends LstObjectFileLoader {
    private boolean defaultFeatsLoaded = false;

    public PObject parseLine(PObject target, String lstLine, CampaignSourceEntry source) throws PersistenceLayerException {
        Feat feat = (Feat)target;
        if (feat == null) {
            feat = new Feat();
        }
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        int col = 0;
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            int len = colString.length();
            if (col == 0) {
                feat.setName(colString);
                feat.setSourceCampaign(source.getCampaign());
                feat.setSourceFile(source.getFile());
            } else {
                if (PObjectLoader.parseTag(feat, colString)) continue;
                if (colString.startsWith("ADD:")) {
                    feat.setAddString(colString.substring(4));
                } else if (len > 14 && colString.startsWith("ADDSPELLLEVEL:")) {
                    try {
                        feat.setAddSpellLevel(Delta.parseInt(colString.substring(14)));
                    }
                    catch (NumberFormatException nfe) {
                        Logging.errorPrint("Bad addSpellLevel " + colString);
                    }
                } else if (colString.startsWith("BENEFIT:")) {
                    feat.setBenefit(colString.substring(8));
                } else if (colString.startsWith("COST:")) {
                    feat.setCost(colString.substring(5));
                } else if (colString.startsWith("MULT:")) {
                    feat.setMultiples(colString.substring(5));
                } else if (colString.startsWith("QUALIFY:")) {
                    feat.setQualifyString(colString.substring(8));
                } else if (colString.startsWith("REP:")) {
                    try {
                        feat.setLevelsPerRepIncrease(Delta.decode(colString.substring(4)));
                    }
                    catch (NumberFormatException nfe) {
                        Logging.errorPrint("Bad level per value " + colString);
                    }
                } else if (colString.startsWith("STACK:")) {
                    feat.setStacks(colString.substring(6));
                } else if (colString.startsWith("VISIBLE:")) {
                    String visType = colString.substring(8).toUpperCase();
                    if (visType.startsWith("EXPORT")) {
                        feat.setVisible(2);
                    } else if (visType.startsWith("NO")) {
                        feat.setVisible(0);
                    } else if (visType.startsWith("DISPLAY")) {
                        feat.setVisible(3);
                    } else {
                        feat.setVisible(1);
                    }
                } else {
                    Logging.errorPrint("Unknown tag '" + colString + "' in " + source.getFile());
                }
            }
            ++col;
        }
        this.finishObject(feat);
        return null;
    }

    protected PObject getObjectNamed(String baseName) {
        return Globals.getFeatNamed(baseName);
    }

    protected void finishObject(PObject target) {
        Feat aFeat;
        if (this.includeObject(target) && (aFeat = Globals.getFeatNamed(target.getKeyName())) == null) {
            Globals.getFeatList().add(target);
        }
    }

    protected void loadLstFile(CampaignSourceEntry sourceEntry) {
        super.loadLstFile(sourceEntry);
        this.loadDefaultFeats(sourceEntry);
    }

    protected void performForget(PObject objToForget) {
        Globals.getFeatList().remove(objToForget);
    }

    private void loadDefaultFeats(CampaignSourceEntry firstSource) {
        if (!this.defaultFeatsLoaded && Globals.getFeatNamed("PCGENi_WEAPON_PROFICIENCY") == null) {
            String aLine = "PCGENi_WEAPON_PROFICIENCY\tOUTPUTNAME:Weapon Proficiency\tTYPE:General\tVISIBLE:NO\tMULT:YES\tSTACK:YES\tDESC:You attack with this specific weapon normally, non-proficiency incurs a -4 to hit penalty.\tSOURCE:PCGen Internal";
            try {
                this.parseLine(null, aLine, firstSource);
            }
            catch (PersistenceLayerException ple) {
                Logging.errorPrint("Unable to parse the internal default feats '" + aLine + "': " + ple.getMessage());
            }
            this.defaultFeatsLoaded = true;
        }
    }
}

