/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.File;
import java.util.StringTokenizer;
import pcgen.core.GameMode;
import pcgen.core.PObject;
import pcgen.core.character.WieldCategory;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class GameModeLoader {
    private GameModeLoader() {
    }

    public static void parseMiscGameInfoLine(GameMode gameMode, String aLine, File aFile, int lineNum) throws PersistenceLayerException {
        if (gameMode == null) {
            return;
        }
        if (aLine.startsWith("ALIGNMENTNAME:")) {
            gameMode.setAlignmentText(aLine.substring(14));
        } else if (aLine.startsWith("ACNAME:")) {
            gameMode.setACText(aLine.substring(7));
        } else if (aLine.startsWith("ACABBREV:")) {
            gameMode.setACAbbrev(aLine.substring(9));
        } else if (aLine.startsWith("ACTYPE:")) {
            gameMode.addACType(aLine.substring(7));
        } else if (aLine.startsWith("ALLOWEDMODES:")) {
            gameMode.setAllowedModes(aLine.substring(13));
        } else if (aLine.startsWith("ALTHPNAME:")) {
            gameMode.setAltHPText(aLine.substring(10));
        } else if (aLine.startsWith("ALTHPABBREV:")) {
            gameMode.setAltHPAbbrev(aLine.substring(12));
        } else if (aLine.startsWith("BABMAXATT:")) {
            gameMode.setBabMaxAtt(Integer.parseInt(aLine.substring(10)));
        } else if (aLine.startsWith("BABMAXLVL:")) {
            gameMode.setBabMaxLvl(Integer.parseInt(aLine.substring(10)));
        } else if (aLine.startsWith("BABATTCYC:")) {
            gameMode.setBabAttCyc(Integer.parseInt(aLine.substring(10)));
        } else if (aLine.startsWith("BABMINVAL:")) {
            gameMode.setBabMinVal(Integer.parseInt(aLine.substring(10)));
        } else if (aLine.startsWith("BASEDICE:")) {
            GameModeLoader.parseBaseDiceLine(gameMode, aLine);
        } else if (aLine.startsWith("BONUS_ACFLAT:")) {
            gameMode.setAcFlatBonus(aLine.substring(13));
        } else if (aLine.startsWith("BONUS_ACTOUCH:")) {
            gameMode.setAcTouchBonus(aLine.substring(14));
        } else if (aLine.startsWith("BONUSFEATLEVELSTARTINTERVAL:")) {
            gameMode.setBonusFeatLevels(aLine.substring(28));
        } else if (aLine.startsWith("BONUSSTATLEVELSTARTINTERVAL:")) {
            gameMode.setBonusStatLevels(aLine.substring(28));
        } else if (aLine.startsWith("CHECKSMAXLVL:")) {
            gameMode.setChecksMaxLvl(Integer.parseInt(aLine.substring(13)));
        } else if (aLine.startsWith("CLASSTYPE:")) {
            gameMode.addClassType(aLine.substring(10));
        } else if (aLine.startsWith("CURRENCYUNIT:")) {
            gameMode.setCurrencyUnit(aLine.substring(13));
        } else if (aLine.startsWith("CURRENCYUNITABBREV:")) {
            gameMode.setCurrencyUnitAbbrev(aLine.substring(19));
        } else if (aLine.startsWith("DAMAGERESISTANCE:")) {
            gameMode.setDamageResistanceText(aLine.substring(17));
        } else if (aLine.startsWith("DEFAULTSPELLBOOK:")) {
            gameMode.setDefaultSpellBook(aLine.substring(17));
        } else if (aLine.startsWith("DEITY:")) {
            gameMode.addDeityList(aLine.substring(6));
        } else if (aLine.startsWith("DISPLAYORDER:")) {
            gameMode.setDisplayOrder(aLine.substring(13));
        } else if (aLine.startsWith("DISPLAYVARIABLE1TEXT:")) {
            gameMode.setVariableDisplayText(aLine.substring(21));
        } else if (aLine.startsWith("DISPLAYVARIABLE1NAME:")) {
            gameMode.setVariableDisplayName(aLine.substring(21));
        } else if (aLine.startsWith("DISPLAYVARIABLE2TEXT:")) {
            gameMode.setVariableDisplay2Text(aLine.substring(21));
        } else if (aLine.startsWith("DISPLAYVARIABLE2NAME:")) {
            gameMode.setVariableDisplay2Name(aLine.substring(21));
        } else if (aLine.startsWith("DISPLAYVARIABLE3TEXT:")) {
            gameMode.setVariableDisplay3Text(aLine.substring(21));
        } else if (aLine.startsWith("DISPLAYVARIABLE3NAME:")) {
            gameMode.setVariableDisplay3Name(aLine.substring(21));
        } else if (aLine.startsWith("EQSIZEPENALTY:")) {
            GameModeLoader.parseEqSizePenaltyLine(gameMode, aLine);
        } else if (aLine.startsWith("HEIGHTUNITABBREV:")) {
            Logging.errorPrint("Deprecated misc. game info " + aFile.getName() + ":" + Integer.toString(lineNum) + " \"" + aLine + "\"");
        } else if (aLine.startsWith("HPNAME:")) {
            gameMode.setHPText(aLine.substring(7));
        } else if (aLine.startsWith("HPABBREV:")) {
            gameMode.setHPAbbrev(aLine.substring(9));
        } else if (aLine.startsWith("LEVELMSG:")) {
            gameMode.setLevelUpMessage(aLine.substring(9).replace('|', '\n'));
        } else if (aLine.startsWith("LEVELMSG2:")) {
            gameMode.setLevelDownMessage(aLine.substring(10).replace('|', '\n'));
        } else if (aLine.startsWith("MENUENTRY:")) {
            gameMode.setModeName(aLine.substring(10));
        } else if (aLine.startsWith("MENUTOOLTIP:")) {
            gameMode.setModeToolTip(aLine.substring(12));
        } else if (aLine.startsWith("MOVEUNIT:")) {
            Logging.errorPrint("Deprecated misc. game info " + aFile.getName() + ":" + Integer.toString(lineNum) + " \"" + aLine + "\"");
        } else if (aLine.startsWith("MOVEUNITABBREV:")) {
            Logging.errorPrint("Deprecated misc. game info " + aFile.getName() + ":" + Integer.toString(lineNum) + " \"" + aLine + "\"");
        } else if (aLine.startsWith("PLUSCOST:")) {
            gameMode.addPlusCalculation(aLine.substring(9));
        } else if (aLine.startsWith("SHOWCLASSDEFENSE:")) {
            gameMode.setShowClassDefense(aLine.charAt(17) == 'Y');
        } else if (aLine.startsWith("SHORTRANGE:")) {
            gameMode.setShortRangeDistance(Integer.parseInt(aLine.substring(11)));
        } else if (aLine.startsWith("SHOWTAB:")) {
            aLine = aLine.substring(8);
            StringTokenizer aTok = new StringTokenizer(aLine, "|");
            String tabName = aTok.nextToken();
            String anArg = aTok.nextToken();
            int iTab = GameMode.getTabNumber(tabName);
            if (iTab == -1) {
                return;
            }
            gameMode.setTabVisible(iTab, anArg);
        } else if (aLine.startsWith("SKILLMULTIPLIER:")) {
            gameMode.setSkillMultiplierLevels(aLine.substring(16));
        } else if (aLine.startsWith("SPELLBASEDC:")) {
            gameMode.setSpellBaseDC(aLine.substring(12));
        } else if (aLine.startsWith("SPELLRANGE:")) {
            gameMode.setSpellRangeFormula(aLine.substring(11));
        } else if (aLine.startsWith("TAB:")) {
            GameModeLoader.parseTabLine(gameMode, aLine);
        } else if (aLine.startsWith("WEAPONCATEGORY:")) {
            gameMode.addWeaponCategory(aLine.substring(15));
        } else if (aLine.startsWith("WEAPONTYPE:")) {
            gameMode.addWeaponType(aLine.substring(11));
        } else if (aLine.startsWith("WEIGHTUNITABBREV:")) {
            Logging.errorPrint("Deprecated misc. game info " + aFile.getName() + ":" + Integer.toString(lineNum) + " \"" + aLine + "\"");
        } else if (aLine.startsWith("WCSTEPSFORMULA:")) {
            gameMode.setWCStepsFormula(aLine.substring(15));
        } else if (aLine.startsWith("WIELDCATEGORY:")) {
            GameModeLoader.parseWieldCategoryLine(gameMode, aLine);
        } else {
            Logging.errorPrint("Illegal misc. game info " + aFile.getName() + ":" + Integer.toString(lineNum) + " \"" + aLine + "\"");
        }
    }

    private static void parseBaseDiceLine(GameMode gameMode, String aLine) {
        StringTokenizer aTok = new StringTokenizer(aLine.substring(9), "\t");
        try {
            String baseDice = aTok.nextToken();
            String upString = "";
            String downString = "";
            while (aTok.hasMoreTokens()) {
                String bString = aTok.nextToken();
                if (bString.startsWith("UP:")) {
                    upString = bString.substring(3);
                    continue;
                }
                if (bString.startsWith("DOWN:")) {
                    downString = bString.substring(5);
                    continue;
                }
                Logging.errorPrint("Invalid sub tag " + bString + " on BASEDICE line");
            }
            if (!gameMode.getDamageUpMap().containsKey(baseDice)) {
                gameMode.getDamageUpMap().put(baseDice, upString);
                gameMode.getDamageDownMap().put(baseDice, downString);
            } else {
                Logging.errorPrint("Duplicate BASEDICE: tag on gamemode.");
            }
        }
        catch (Exception e) {
            Logging.errorPrint("Problems loading line - " + aLine);
        }
    }

    private static void parseEqSizePenaltyLine(GameMode gameMode, String aLine) throws PersistenceLayerException {
        PObject eqSizePenaltyObj = new PObject();
        StringTokenizer colToken = new StringTokenizer(aLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (colString.startsWith("EQSIZEPENALTY:")) {
                eqSizePenaltyObj.setName(colString.substring(14));
                continue;
            }
            if (PObjectLoader.parseTag(eqSizePenaltyObj, colString)) continue;
            Logging.errorPrint("Illegal Value in EQSIZEPENALTY line: " + colString);
        }
        gameMode.setEqSizePenaltyObj(eqSizePenaltyObj);
    }

    private static void parseTabLine(GameMode gameMode, String aLine) {
        StringTokenizer aTok = new StringTokenizer(aLine, "\t");
        int iTab = -1;
        while (aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            if (aString.startsWith("CONTEXT:")) {
                gameMode.setTabContext(iTab, aString.substring(8));
                continue;
            }
            if (aString.startsWith("NAME:")) {
                gameMode.setTabName(iTab, aString.substring(5));
                continue;
            }
            if (aString.startsWith("TAB:")) {
                iTab = GameMode.getTabNumber(aString.substring(4));
                if (iTab != -1) continue;
                return;
            }
            if (!aString.startsWith("VISIBLE:")) continue;
            gameMode.setTabVisible(iTab, aString.substring(8));
        }
    }

    private static void parseWieldCategoryLine(GameMode gameMode, String aLine) {
        StringTokenizer aTok = new StringTokenizer(aLine, "\t");
        WieldCategory wCat = null;
        String preKey = null;
        String preVal = null;
        while (aTok.hasMoreTokens()) {
            int count;
            String dString;
            String aName;
            String aString = aTok.nextToken();
            if (aString.startsWith("WIELDCATEGORY:") && (wCat = gameMode.getWieldCategory(aName = aString.substring(14))) == null) {
                wCat = new WieldCategory(aName);
                gameMode.addWieldCategory(wCat);
            }
            if (wCat == null) continue;
            if (aString.startsWith("DAMAGEMULT:")) {
                dString = aString.substring(11);
                StringTokenizer dTok = new StringTokenizer(dString, ",");
                while (dTok.hasMoreTokens()) {
                    String cString = dTok.nextToken();
                    StringTokenizer cTok = new StringTokenizer(cString, "=");
                    if (cTok.countTokens() < 2) continue;
                    String aKey = cTok.nextToken();
                    String aVal = cTok.nextToken();
                    wCat.addDamageMultMap(aKey, aVal);
                }
                continue;
            }
            if (aString.startsWith("FINESSABLE:")) {
                if (!aString.substring(11).startsWith("Y")) continue;
                wCat.setFinessable(true);
                continue;
            }
            if (aString.startsWith("HANDS:")) {
                Integer hands = new Integer(aString.substring(6));
                wCat.setHands(hands);
                continue;
            }
            if (aString.startsWith("PREVAR")) {
                preKey = aString;
                continue;
            }
            if (aString.startsWith("SWITCH:")) {
                preVal = aString.substring(7);
                continue;
            }
            if (aString.startsWith("SIZEDIFF:")) {
                Integer sInt = new Integer(aString.substring(9));
                wCat.setSizeDiff(sInt);
                continue;
            }
            if (aString.startsWith("UP:")) {
                dString = aString.substring(3);
                StringTokenizer dTok = new StringTokenizer(dString, "|");
                count = 1;
                while (dTok.hasMoreTokens()) {
                    dString = dTok.nextToken();
                    wCat.setWCStep(count, dString);
                    ++count;
                }
                continue;
            }
            if (aString.startsWith("DOWN:")) {
                dString = aString.substring(5);
                StringTokenizer dTok = new StringTokenizer(dString, "|");
                count = -1;
                while (dTok.hasMoreTokens()) {
                    dString = dTok.nextToken();
                    wCat.setWCStep(count, dString);
                    --count;
                }
                continue;
            }
            if (!aString.startsWith("ZERO:")) continue;
            dString = aString.substring(5);
            int count2 = 0;
            wCat.setWCStep(count2, dString);
        }
        if (wCat != null && preVal != null && preKey != null) {
            wCat.addSwitchMap(preKey, preVal);
        }
    }
}

