/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.Constants;
import pcgen.core.Kit;
import pcgen.core.kit.KitFeat;
import pcgen.core.kit.KitGear;
import pcgen.core.kit.KitProf;
import pcgen.core.kit.KitSchool;
import pcgen.core.kit.KitSkill;
import pcgen.core.kit.KitSpells;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class KitLoader {
    private KitLoader() {
    }

    public static void parseLine(Kit obj, String inputLine, URL sourceURL, int lineNum) throws PersistenceLayerException {
        if (inputLine.startsWith("STARTPACK:")) {
            KitLoader.parseNameLine(obj, inputLine, sourceURL, lineNum);
        } else if (inputLine.startsWith("FEAT:")) {
            KitLoader.parseFeatLine(obj, inputLine, sourceURL, lineNum);
        } else if (inputLine.startsWith("GEAR:")) {
            KitLoader.parseGearLine(obj, inputLine, sourceURL, lineNum);
        } else if (inputLine.startsWith("LANGAUTO:")) {
            KitLoader.parseNameLine(obj, inputLine, sourceURL, lineNum);
        } else if (inputLine.startsWith("PROF:")) {
            KitLoader.parseProfLine(obj, inputLine, sourceURL, lineNum);
        } else if (inputLine.startsWith("SCHOOL:")) {
            KitLoader.parseSchoolLine(obj, inputLine, sourceURL, lineNum);
        } else if (inputLine.startsWith("SKILL:")) {
            KitLoader.parseSkillLine(obj, inputLine, sourceURL, lineNum);
        } else if (inputLine.startsWith("SPELLS:")) {
            KitLoader.parseSpellsLine(obj, inputLine, sourceURL, lineNum);
        } else if (inputLine.startsWith("TEMPLATE:")) {
            KitLoader.parseTemplateLine(obj, inputLine, sourceURL, lineNum);
        } else {
            Logging.errorPrint("Unknown kit info " + sourceURL.toString() + ":" + Integer.toString(lineNum) + " \"" + inputLine + "\"");
        }
    }

    private static void parseFeatLine(Kit obj, String inputLine, URL sourceURL, int lineNum) throws PersistenceLayerException {
        KitFeat kFeat = null;
        StringTokenizer colToken = new StringTokenizer(inputLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken();
            if (colString.startsWith("FEAT:")) {
                if (kFeat == null) {
                    kFeat = new KitFeat(colString.substring(5));
                    continue;
                }
                Logging.errorPrint("Ignoring second FEAT tag \"" + colString + "\" in Kit.parseFeatLine");
                continue;
            }
            if (kFeat == null) {
                Logging.errorPrint("Cannot process tag, missing FEAT tag." + Constants.s_LINE_SEP + colString);
                continue;
            }
            if (colString.startsWith("FREE:")) {
                kFeat.setFree(colString.charAt(5) == 'Y');
                continue;
            }
            if (colString.startsWith("COUNT:")) {
                kFeat.setChoiceCount(colString.substring(6));
                continue;
            }
            if (colString.startsWith("PRE") || colString.startsWith("!PRE")) {
                kFeat.addPreReq(colString);
                continue;
            }
            throw new PersistenceLayerException("Unknown KitFeat info " + sourceURL.toString() + ":" + Integer.toString(lineNum) + " \"" + colString + "\"");
        }
        obj.addFeat(kFeat);
    }

    private static void parseGearLine(Kit obj, String inputLine, URL sourceURL, int lineNum) throws PersistenceLayerException {
        KitGear kGear = null;
        StringTokenizer colToken = new StringTokenizer(inputLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken();
            if (colString.startsWith("GEAR:")) {
                if (kGear == null) {
                    kGear = new KitGear(colString.substring(5));
                    continue;
                }
                Logging.errorPrint("Ignoring second GEAR tag \"" + colString + "\" in Kit.parseGearLine");
                continue;
            }
            if (kGear == null) {
                Logging.errorPrint("Cannot process tag, missing GEAR tag." + Constants.s_LINE_SEP + colString);
                continue;
            }
            if (colString.startsWith("EQMOD:")) {
                kGear.addEqMod(colString.substring(6));
                continue;
            }
            if (colString.startsWith("PRE") || colString.startsWith("!PRE")) {
                kGear.addPreReq(colString);
                continue;
            }
            if (colString.startsWith("QTY:")) {
                kGear.setQty(colString.substring(4));
                continue;
            }
            if (colString.startsWith("MAXCOST:")) {
                kGear.setMaxCost(colString.substring(8));
                continue;
            }
            if (colString.startsWith("SPROP:") || colString.startsWith("LEVEL:")) {
                Logging.errorPrint("unhandled parsed object in KitLoader.parseGearLine: " + colString);
                continue;
            }
            throw new PersistenceLayerException("Unknown KitGear info " + sourceURL.toString() + ":" + Integer.toString(lineNum) + " \"" + colString + "\"");
        }
        obj.addGear(kGear);
    }

    private static void parseNameLine(Kit obj, String inputLine, URL sourceURL, int lineNum) throws PersistenceLayerException {
        if (obj == null) {
            return;
        }
        StringTokenizer colToken = new StringTokenizer(inputLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken();
            if (PObjectLoader.parseTag(obj, colString)) continue;
            if (colString.startsWith("STARTPACK:")) {
                obj.setName(colString.substring(10));
                continue;
            }
            if (colString.startsWith("EQUIPBUY:")) {
                obj.setBuyRate(colString.substring(9));
                continue;
            }
            if (colString.startsWith("EQUIPSELL:")) {
                obj.setSellRate(colString.substring(10));
                continue;
            }
            throw new PersistenceLayerException("Unknown KitPack info " + sourceURL.toString() + ":" + Integer.toString(lineNum) + " \"" + colString + "\"");
        }
    }

    private static void parseProfLine(Kit obj, String inputLine, URL sourceURL, int lineNum) throws PersistenceLayerException {
        KitProf kProf = null;
        StringTokenizer colToken = new StringTokenizer(inputLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken();
            if (colString.startsWith("PROF:")) {
                if (kProf == null) {
                    kProf = new KitProf(colString.substring(5));
                    continue;
                }
                Logging.errorPrint("Ignoring second PROF tag \"" + colString + "\" in Kit.parseProfLine");
                continue;
            }
            if (kProf == null) {
                Logging.errorPrint("Cannot process tag, missing PROF tag." + Constants.s_LINE_SEP + colString);
                continue;
            }
            if (colString.startsWith("COUNT:")) {
                kProf.setChoiceCount(colString.substring(6));
                continue;
            }
            if (colString.startsWith("PRE") || colString.startsWith("!PRE")) {
                kProf.addPreReq(colString);
                continue;
            }
            if (colString.startsWith("RACIAL:")) {
                kProf.setRacialProf(colString.charAt(7) == 'Y');
                continue;
            }
            throw new PersistenceLayerException("Unknown KitProf info " + sourceURL.toString() + ":" + Integer.toString(lineNum) + " \"" + colString + "\"");
        }
        obj.addProf(kProf);
    }

    private static void parseSchoolLine(Kit obj, String inputLine, URL sourceURL, int lineNum) throws PersistenceLayerException {
        KitSchool kSchool = null;
        StringTokenizer colToken = new StringTokenizer(inputLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken();
            if (colString.startsWith("SCHOOL:")) {
                if (kSchool == null) {
                    kSchool = new KitSchool(colString.substring(7));
                    continue;
                }
                Logging.errorPrint("Ignoring second SCHOOL tag \"" + colString + "\" in Kit.parseSchoolLine");
                continue;
            }
            if (kSchool == null) {
                Logging.errorPrint("Cannot process tag, missing SCHOOL tag." + Constants.s_LINE_SEP + colString);
                continue;
            }
            if (colString.startsWith("PROHIBITED:")) {
                StringTokenizer aTok = new StringTokenizer(colString.substring(11), "|");
                while (aTok.hasMoreTokens()) {
                    kSchool.addProhibited(aTok.nextToken());
                }
                continue;
            }
            if (colString.startsWith("PRE") || colString.startsWith("!PRE")) {
                kSchool.addPreReq(colString);
                continue;
            }
            throw new PersistenceLayerException("Unknown KitSchool info " + sourceURL.toString() + ":" + Integer.toString(lineNum) + " \"" + colString + "\"");
        }
        obj.setSchool(kSchool);
    }

    private static void parseSkillLine(Kit obj, String inputLine, URL sourceURL, int lineNum) throws PersistenceLayerException {
        KitSkill kSkill = null;
        StringTokenizer colToken = new StringTokenizer(inputLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken();
            if (colString.startsWith("SKILL:")) {
                if (kSkill == null) {
                    kSkill = new KitSkill(colString.substring(6));
                    continue;
                }
                Logging.errorPrint("Ignoring second SKILL tag \"" + colString + "\" in Kit.parseSkillLine");
                continue;
            }
            if (kSkill == null) {
                Logging.errorPrint("Cannot process tag, missing SKILL tag." + Constants.s_LINE_SEP + colString);
                continue;
            }
            if (colString.startsWith("RANK:")) {
                kSkill.setRank(colString.substring(5));
                continue;
            }
            if (colString.startsWith("FREE:")) {
                kSkill.setFree(colString.substring(5).startsWith("Y"));
                continue;
            }
            if (colString.startsWith("PRE") || colString.startsWith("!PRE")) {
                kSkill.addPreReq(colString);
                continue;
            }
            throw new PersistenceLayerException("Unknown KitSkill info " + sourceURL.toString() + ":" + Integer.toString(lineNum) + " \"" + colString + "\"");
        }
        obj.addSkill(kSkill);
    }

    private static void parseSpellsLine(Kit obj, String inputLine, URL sourceURL, int lineNum) throws PersistenceLayerException {
        KitSpells kSpells = new KitSpells();
        StringTokenizer colToken = new StringTokenizer(inputLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken();
            if (colString.startsWith("SPELLS:")) {
                StringTokenizer aTok = new StringTokenizer(colString.substring(7), "|");
                while (aTok.hasMoreTokens()) {
                    kSpells.addSpell(aTok.nextToken());
                }
                continue;
            }
            if (colString.startsWith("COUNT:")) {
                kSpells.setCountFormula(colString.substring(6));
                continue;
            }
            if (colString.startsWith("PRE") || colString.startsWith("!PRE")) {
                kSpells.addPreReq(colString);
                continue;
            }
            throw new PersistenceLayerException("Unknown KitSpells info " + sourceURL.toString() + ":" + Integer.toString(lineNum) + " \"" + colString + "\"");
        }
        obj.addSpells(kSpells);
    }

    private static void parseTemplateLine(Kit obj, String inputLine, URL sourceURL, int lineNum) throws PersistenceLayerException {
        obj.setTemplateString(inputLine.substring(9));
    }
}

