/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class LanguageLoader
extends LstObjectFileLoader {
    public PObject parseLine(PObject target, String lstLine, CampaignSourceEntry source) throws PersistenceLayerException {
        Language obj = (Language)target;
        if (obj == null) {
            obj = new Language();
        }
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        int col = 0;
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken();
            if (col == 0) {
                obj.setName(colString);
                obj.setSourceCampaign(source.getCampaign());
                obj.setSourceFile(source.getFile());
            } else {
                if (PObjectLoader.parseTag(obj, colString)) continue;
                Logging.errorPrint("Unknown tag '" + colString + "' in " + source.getFile());
            }
            ++col;
        }
        this.finishObject(obj);
        return null;
    }

    protected PObject getObjectNamed(String baseName) {
        return Globals.getLanguageNamed(baseName);
    }

    protected void finishObject(PObject target) {
        Language lang;
        if (this.includeObject(target) && (lang = Globals.getLanguageNamed(target.getName())) == null) {
            Globals.getLanguageList().add(target);
        }
    }

    protected void performForget(PObject objToForget) {
        Globals.getLanguageList().remove(objToForget);
    }
}

