/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.StringTokenizer;
import pcgen.core.LevelInfo;
import pcgen.util.Logging;

final class LevelLoader {
    private static final String levelTag = "LEVEL:";
    private static final String minXPTag = "MINXP:";
    private static final String maxClassSkillTag = "CSKILLMAX:";
    private static final String maxCrossClassSkillTag = "CCSKILLMAX:";

    private LevelLoader() {
    }

    public static void parseLine(LevelInfo levelInfo, String inputLine, int lineNum) {
        if (levelInfo == null) {
            return;
        }
        StringTokenizer aTok = new StringTokenizer(inputLine, "\t");
        while (aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            if (aString.startsWith(levelTag)) {
                levelInfo.setLevelString(aString.substring(levelTag.length()));
                continue;
            }
            if (aString.startsWith(maxClassSkillTag)) {
                levelInfo.setMaxClassSkillString(aString.substring(maxClassSkillTag.length()));
                continue;
            }
            if (aString.startsWith(maxCrossClassSkillTag)) {
                levelInfo.setMaxCrossClassSkillString(aString.substring(maxCrossClassSkillTag.length()));
                continue;
            }
            if (aString.startsWith(minXPTag)) {
                levelInfo.setMinXPString(aString.substring(minXPTag.length()));
                continue;
            }
            Logging.errorPrint("LevelLoader got unexpected token of '" + aString + "' at line " + lineNum + ". Token ignored.");
        }
    }
}

