/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Observable;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.persistence.PersistenceLayerException;
import pcgen.util.Logging;

public abstract class LstFileLoader
extends Observable {
    public abstract void loadLstFiles(List var1) throws PersistenceLayerException;

    public void logError(String message) {
        Logging.errorPrint(message);
        this.setChanged();
        this.notifyObservers(new Exception(message));
    }

    public static URL readFileGetURL(String argFileName, StringBuffer dataBuffer) throws PersistenceLayerException {
        if (argFileName.length() <= 0) {
            throw new PersistenceLayerException("LstFileLoader.readFileGetURL() has a blank argFileName!");
        }
        String fileName = argFileName;
        if (!CoreUtility.isURL(fileName)) {
            fileName = CoreUtility.fixFilenamePath(fileName);
        }
        URL aURL = CoreUtility.isURL(fileName) ? LstFileLoader.readFromURL(fileName, dataBuffer) : LstFileLoader.readFromFile(fileName, dataBuffer);
        return aURL;
    }

    protected final boolean isComment(String line) {
        return line.length() == 0 || line.startsWith("#");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static URL readFromFile(String fileName, StringBuffer dataBuffer) throws PersistenceLayerException {
        URL aURL = null;
        InputStream inputStream = null;
        File aFile = new File(fileName);
        if (!aFile.exists()) {
            Logging.debugPrint(fileName + " doesn't seem to exist!");
            return null;
        }
        aURL = aFile.toURL();
        int length = (int)aFile.length();
        inputStream = new FileInputStream(aFile);
        byte[] inputLine = new byte[length];
        int bytesRead = inputStream.read(inputLine, 0, length);
        if (bytesRead != length) {
            Logging.errorPrint("Only read " + bytesRead + " bytes from " + fileName + " but expected " + length + " in LstSystemLoader.initFile. Continuing anyway");
        }
        dataBuffer.append(new String(inputLine));
        Object var9_9 = null;
        if (inputStream == null) return aURL;
        try {
            inputStream.close();
            return aURL;
        }
        catch (IOException e2) {
            Logging.errorPrint("Can't close inputStream in LstSystemLoader.initFile", e2);
        }
        return aURL;
        {
            catch (IOException ioe) {
                aURL = null;
                Logging.errorPrint("ERROR:" + fileName + "\n" + "Exception type:" + ioe.getClass().getName() + "\n" + "Message:" + ioe.getMessage());
                Object var9_10 = null;
                if (inputStream == null) return aURL;
                try {
                    inputStream.close();
                    return aURL;
                }
                catch (IOException e2) {
                    Logging.errorPrint("Can't close inputStream in LstSystemLoader.initFile", e2);
                }
                return aURL;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e2) {
                Logging.errorPrint("Can't close inputStream in LstSystemLoader.initFile", e2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static URL readFromURL(String url, StringBuffer dataBuffer) throws PersistenceLayerException {
        InputStream inputStream;
        URL aURL;
        block10: {
            aURL = null;
            inputStream = null;
            if (!CoreUtility.isNetURL(url) || SettingsHandler.isLoadURLs()) {
                int n;
                aURL = new URL(url);
                inputStream = aURL.openStream();
                InputStreamReader ir = new InputStreamReader(inputStream);
                char[] b = new char[512];
                while ((n = ir.read(b)) > 0) {
                    dataBuffer.append(b, 0, n);
                }
                break block10;
            }
            ShowMessageDelegate.showMessageDialog("Preferences are currently set to NOT allow\nloading of sources from web links. \n" + url + " is a web link", "PCGen", MessageType.ERROR);
            aURL = null;
        }
        Object var8_8 = null;
        if (inputStream == null) return aURL;
        try {
            inputStream.close();
            return aURL;
        }
        catch (IOException e2) {
            Logging.errorPrint("Can't close inputStream in LstSystemLoader.initFile", e2);
        }
        return aURL;
        {
            catch (IOException ioe) {
                aURL = null;
                Logging.errorPrint("ERROR:" + url + "\n" + "Exception type:" + ioe.getClass().getName() + "\n" + "Message:" + ioe.getMessage());
                Object var8_9 = null;
                if (inputStream == null) return aURL;
                try {
                    inputStream.close();
                    return aURL;
                }
                catch (IOException e2) {
                    Logging.errorPrint("Can't close inputStream in LstSystemLoader.initFile", e2);
                }
                return aURL;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e2) {
                Logging.errorPrint("Can't close inputStream in LstSystemLoader.initFile", e2);
            }
            throw throwable;
        }
    }
}

