/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.core.PObject;
import pcgen.core.utils.CoreUtility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.persistence.lst.PObjectLoader;

public abstract class LstObjectFileLoader
extends LstFileLoader {
    private CampaignSourceEntry currentSource = null;
    private List copyLineList = new ArrayList();
    private List forgetLineList = new ArrayList();
    private List modEntryList = new ArrayList();
    private Map sourceMap = null;

    public void loadLstFiles(List fileList) {
        this.sortFilesForOptimalLoad(fileList);
        TreeSet<String> loadedFiles = new TreeSet<String>();
        Iterator fileIter = fileList.iterator();
        while (fileIter.hasNext()) {
            Object testObj = fileIter.next();
            if (testObj == null) continue;
            if (!(testObj instanceof CampaignSourceEntry)) {
                this.logError("Found " + testObj.getClass().getName() + " - " + testObj.toString() + " when expecting a CampaignSourceEntry.");
                continue;
            }
            CampaignSourceEntry sourceEntry = (CampaignSourceEntry)testObj;
            String fileName = sourceEntry.getFile();
            if (loadedFiles.contains(fileName)) continue;
            this.loadLstFile(sourceEntry);
            loadedFiles.add(fileName);
        }
        this.processCopies();
        this.processMods();
        this.processForgets();
    }

    public abstract PObject parseLine(PObject var1, String var2, CampaignSourceEntry var3) throws PersistenceLayerException;

    protected abstract void finishObject(PObject var1);

    protected final boolean includeObject(PObject parsedObject) {
        List includeItems;
        if (parsedObject == null || parsedObject.getName() == null || parsedObject.getName().trim().length() == 0 || parsedObject.getKeyName() == null || parsedObject.getKeyName().trim().length() == 0) {
            return false;
        }
        if (this.sourceMap != null) {
            parsedObject.setSourceMap(this.sourceMap);
        }
        if (!(includeItems = this.currentSource.getIncludeItems()).isEmpty()) {
            return includeItems.contains(parsedObject.getName());
        }
        List excludeItems = this.currentSource.getExcludeItems();
        if (!excludeItems.isEmpty()) {
            return !excludeItems.contains(parsedObject.getName());
        }
        return true;
    }

    protected abstract PObject getObjectNamed(String var1);

    protected void loadLstFile(CampaignSourceEntry sourceEntry) {
        this.setChanged();
        String urlString = "";
        try {
            urlString = CoreUtility.fileToURL(sourceEntry.getFile());
            this.notifyObservers(new URL(urlString));
        }
        catch (MalformedURLException e) {
            try {
                this.setChanged();
                this.notifyObservers(new Exception("Can not create URL for: " + urlString));
                this.setChanged();
                this.notifyObservers(new URL("http://f"));
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
        this.sourceMap = null;
        this.currentSource = sourceEntry;
        StringBuffer dataBuffer = new StringBuffer();
        try {
            LstObjectFileLoader.readFileGetURL(sourceEntry.getFile(), dataBuffer);
        }
        catch (PersistenceLayerException ple) {
            this.logError("Unable to load the file: '" + sourceEntry.getFile() + "': " + ple.getMessage());
        }
        String newlinedelim = "\r\n";
        String aString = dataBuffer.toString();
        StringTokenizer fileLines = new StringTokenizer(aString, "\r\n");
        PObject target = null;
        int currentLineNumber = 0;
        while (fileLines.hasMoreTokens()) {
            ++currentLineNumber;
            String line = fileLines.nextToken().trim();
            if (line.length() == 0 || line.startsWith("#")) continue;
            if (line.startsWith("SOURCE")) {
                this.sourceMap = PObjectLoader.parseSource(line);
                continue;
            }
            if (line.indexOf(".COPY") > 0) {
                this.copyLineList.add(line);
                continue;
            }
            if (line.indexOf(".MOD") > 0 && !line.startsWith("CLASS:")) {
                this.modEntryList.add(new ModEntry(sourceEntry, line, currentLineNumber));
                continue;
            }
            if (line.indexOf(".FORGET") > 0) {
                this.forgetLineList.add(line);
                continue;
            }
            try {
                target = this.parseLine(target, line, sourceEntry);
                this.finishObject(target);
            }
            catch (PersistenceLayerException ple) {
                this.logError("Error parsing file '" + sourceEntry.getFile() + "' line '" + currentLineNumber + "': " + ple.getMessage());
            }
        }
    }

    protected abstract void performForget(PObject var1);

    protected void sortFilesForOptimalLoad(List fileList) {
        if (fileList.isEmpty() || fileList.get(0) instanceof String) {
            return;
        }
        ArrayList<CampaignSourceEntry> normalFiles = new ArrayList<CampaignSourceEntry>();
        ArrayList<CampaignSourceEntry> includeFiles = new ArrayList<CampaignSourceEntry>();
        ArrayList<CampaignSourceEntry> excludeFiles = new ArrayList<CampaignSourceEntry>();
        Iterator iter = fileList.iterator();
        while (iter.hasNext()) {
            CampaignSourceEntry sourceEntry = (CampaignSourceEntry)iter.next();
            String fileInfo = sourceEntry.getFile();
            if (fileInfo.indexOf("INCLUDE") > 0) {
                includeFiles.add(sourceEntry);
                continue;
            }
            if (fileInfo.indexOf("EXCLUDE") > 0) {
                excludeFiles.add(sourceEntry);
                continue;
            }
            normalFiles.add(sourceEntry);
        }
        fileList.clear();
        fileList.addAll(normalFiles);
        fileList.addAll(excludeFiles);
        fileList.addAll(includeFiles);
    }

    private void performCopy(String baseName, String copyName) {
        PObject object = this.getObjectNamed(baseName);
        try {
            if (object == null) {
                this.logError("PObject '" + baseName + "' not found; .COPY skipped.");
                return;
            }
            PObject clone = (PObject)object.clone();
            clone.setName(copyName);
            clone.setKeyName(copyName);
            this.finishObject(clone);
        }
        catch (CloneNotSupportedException e) {
            this.logError(object.getClass().getName() + " clone error; .COPY of " + baseName + " to " + copyName + " skipped.");
        }
    }

    private void performCopy(String lstLine) {
        int nameEnd = lstLine.indexOf(".COPY");
        String baseName = lstLine.substring(0, nameEnd);
        String copyName = lstLine.substring(nameEnd + 6);
        this.performCopy(baseName, copyName);
    }

    private void performForget(String forgetName) {
        PObject objToForget = this.getObjectNamed(forgetName);
        if (objToForget != null) {
            this.performForget(objToForget);
        }
    }

    private void performMod(ModEntry entry) {
        PObject object;
        int nameEnd = entry.getLstLine().indexOf(".MOD");
        String name = entry.getLstLine().substring(0, nameEnd);
        int nameStart = name.indexOf(58);
        if (nameStart > 0) {
            name = name.substring(nameStart + 1);
        }
        if ((object = this.getObjectNamed(name)) == null) {
            this.logError("Cannot apply .MOD; PObject '" + name + "' not found. '" + entry.getSource().getFile() + ":" + entry.getLineNumber() + "'");
        }
        try {
            this.parseLine(object, entry.getLstLine(), entry.getSource());
            this.finishObject(object);
        }
        catch (PersistenceLayerException ple) {
            this.logError("Unable to MOD the object '" + name + "' as it is not possible to parse '" + entry.getSource().getFile() + ":" + entry.getLineNumber() + "': " + ple.getMessage());
        }
    }

    private void processCopies() {
        Iterator copyIter = this.copyLineList.iterator();
        while (copyIter.hasNext()) {
            this.performCopy((String)copyIter.next());
        }
    }

    private void processForgets() {
        Iterator forgetIter = this.forgetLineList.iterator();
        while (forgetIter.hasNext()) {
            String forgetName = (String)forgetIter.next();
            forgetName = forgetName.substring(0, forgetName.indexOf(".FORGET"));
            this.performForget(forgetName);
        }
    }

    private void processMods() {
        Iterator modIter = this.modEntryList.iterator();
        while (modIter.hasNext()) {
            this.performMod((ModEntry)modIter.next());
        }
    }

    public CampaignSourceEntry getCurrentSource() {
        return this.currentSource;
    }

    public void setCurrentSource(CampaignSourceEntry currentSource) {
        this.currentSource = currentSource;
    }

    public static class ModEntry {
        private CampaignSourceEntry source = null;
        private String lstLine = null;
        private int lineNumber = 0;

        public ModEntry(CampaignSourceEntry source, String lstLine, int lineNumber) {
            if (source == null) {
                throw new IllegalArgumentException("source must not be null");
            }
            if (lstLine == null) {
                throw new IllegalArgumentException("lstLine must not be null");
            }
            this.source = source;
            this.lstLine = lstLine;
            this.lineNumber = lineNumber;
        }

        public String getLstLine() {
            return this.lstLine;
        }

        public CampaignSourceEntry getSource() {
            return this.source;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

