/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.core.BioSet;
import pcgen.core.Campaign;
import pcgen.core.Constants;
import pcgen.core.CustomData;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.EquipmentModifier;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.LevelInfo;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SystemCollections;
import pcgen.core.character.CompanionMod;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.pcGenGUI;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.SystemLoader;
import pcgen.persistence.lst.BioSetLoader;
import pcgen.persistence.lst.BonusStackLoader;
import pcgen.persistence.lst.CampaignLoader;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.CompanionModLoader;
import pcgen.persistence.lst.CurrencyParser;
import pcgen.persistence.lst.DeityLoader;
import pcgen.persistence.lst.DomainLoader;
import pcgen.persistence.lst.EquipSlotLoader;
import pcgen.persistence.lst.EquipmentLoader;
import pcgen.persistence.lst.EquipmentModifierLoader;
import pcgen.persistence.lst.FeatLoader;
import pcgen.persistence.lst.GameModeLoader;
import pcgen.persistence.lst.KitLoader;
import pcgen.persistence.lst.LanguageLoader;
import pcgen.persistence.lst.LevelLoader;
import pcgen.persistence.lst.LocationLoader;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.persistence.lst.PCClassLoader;
import pcgen.persistence.lst.PCTemplateLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.PaperInfoLoader;
import pcgen.persistence.lst.PointBuyLoader;
import pcgen.persistence.lst.RaceLoader;
import pcgen.persistence.lst.RuleCheckLoader;
import pcgen.persistence.lst.SchoolListLoader;
import pcgen.persistence.lst.SizeAdjustmentLoader;
import pcgen.persistence.lst.SkillLoader;
import pcgen.persistence.lst.SpecialAbilityLoader;
import pcgen.persistence.lst.SpellLoader;
import pcgen.persistence.lst.StatsAndChecksLoader;
import pcgen.persistence.lst.TraitLoader;
import pcgen.persistence.lst.UnitSetLoader;
import pcgen.persistence.lst.WeaponProfLoader;
import pcgen.util.Logging;

public final class LstSystemLoader
extends Observable
implements SystemLoader,
Observer {
    private static final List pList = new ArrayList();
    private static final int[] loadOrder = new int[]{19, 9, 11, 14, 15, 16, 17, 25, 30};
    private static final int MODE_EXCLUDE = -1;
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_INCLUDE = 1;
    private static final FilenameFilter gameModeFileFilter = new FilenameFilter(){

        public boolean accept(File aFile, String aString) {
            try {
                File d = new File(aFile, aString);
                if (d.isDirectory()) {
                    File f = new File(d, "statsandchecks.lst");
                    if (f.exists()) {
                        f = new File(d, "miscinfo.lst");
                        return f.exists();
                    }
                    return false;
                }
            }
            catch (SecurityException e) {
                Logging.errorPrint("GameModes.listGameFiles", e);
            }
            return false;
        }
    };
    private static int lineNum = 0;
    private BioSetLoader bioLoader = new BioSetLoader();
    private BonusStackLoader bonusLoader = new BonusStackLoader();
    private CampaignLoader campaignLoader = new CampaignLoader();
    private CampaignSourceEntry globalCampaign = new CampaignSourceEntry(new Campaign(), "System Configuration Document");
    private CurrencyParser currencyParser = new CurrencyParser();
    private DeityLoader deityLoader = new DeityLoader();
    private DomainLoader domainLoader = new DomainLoader();
    private EquipSlotLoader eqSlotLoader = new EquipSlotLoader();
    private FeatLoader featLoader = new FeatLoader();
    private final FilenameFilter pccFileFilter = new FilenameFilter(){

        public boolean accept(File aFile, String aString) {
            try {
                if (aString.endsWith(".pcc")) {
                    String fName = aFile.getPath() + File.separator + aString;
                    if (Globals.getCampaignByFilename(fName, false) == null) {
                        LstSystemLoader.this.campaignLoader.loadLstFile(fName);
                    }
                } else if (aFile.isDirectory()) {
                    LstSystemLoader.this.loadPCCFilesInDirectory(aFile.getPath() + File.separator + aString);
                }
            }
            catch (PersistenceLayerException e) {
                LstSystemLoader.this.logError("PersistanceLayer", e);
            }
            return false;
        }
    };
    private LanguageLoader languageLoader = new LanguageLoader();
    private final List bioSetFileList = new ArrayList();
    private final List chosenCampaignSourcefiles = new ArrayList();
    private final List classFileList = new ArrayList();
    private final List classSkillFileList = new ArrayList();
    private final List classSpellFileList = new ArrayList();
    private final List coinFileList = new ArrayList();
    private final List companionmodFileList = new ArrayList();
    private final List deityFileList = new ArrayList();
    private final List domainFileList = new ArrayList();
    private final List equipmentFileList = new ArrayList();
    private final List equipmodFileList = new ArrayList();
    private final List featFileList = new ArrayList();
    private final List forgetFileType = new ArrayList();
    private final List forgetLines = new ArrayList();
    private final List kitFileList = new ArrayList();
    private final List languageFileList = new ArrayList();
    private List licenseFiles = new ArrayList();
    private final List lstExcludeFiles = new ArrayList();
    private final List modFileType = new ArrayList();
    private final List modLines = new ArrayList();
    private final List pccFileList = new ArrayList();
    private final List raceFileList = new ArrayList();
    private final List reqSkillFileList = new ArrayList();
    private final List skillFileList = new ArrayList();
    private final List spellFileList = new ArrayList();
    private final List templateFileList = new ArrayList();
    private final List weaponProfFileList = new ArrayList();
    private LocationLoader locationLoader = new LocationLoader();
    private final Map loadedFiles = new HashMap();
    private PCClassLoader classLoader = new PCClassLoader();
    private PaperInfoLoader paperLoader = new PaperInfoLoader();
    private PointBuyLoader pointBuyLoader = new PointBuyLoader();
    private RaceLoader raceLoader = new RaceLoader();
    private SchoolListLoader schoolLoader = new SchoolListLoader();
    private final Set sourcesSet = new TreeSet();
    private BioSet bioSet = new BioSet();
    private SizeAdjustmentLoader sizeLoader = new SizeAdjustmentLoader();
    private SkillLoader skillLoader = new SkillLoader();
    private SpecialAbilityLoader abilityLoader = new SpecialAbilityLoader();
    private SpellLoader spellLoader = new SpellLoader();
    private StatsAndChecksLoader statCheckLoader = new StatsAndChecksLoader();
    private String currentSource = "";
    private String skillReq = "";
    private StringBuffer licensesToDisplayString = new StringBuffer();
    private TraitLoader traitLoader = new TraitLoader();
    private UnitSetLoader unitLoader = new UnitSetLoader();
    private WeaponProfLoader wProfLoader = new WeaponProfLoader();
    private boolean customItemsLoaded = false;
    private boolean showD20 = false;
    private boolean showLicensed = true;
    private boolean showOGL = false;

    public LstSystemLoader() {
        this.featLoader.addObserver(this);
        this.bioLoader.addObserver(this);
        this.bonusLoader.addObserver(this);
        this.campaignLoader.addObserver(this);
        this.deityLoader.addObserver(this);
        this.domainLoader.addObserver(this);
        this.eqSlotLoader.addObserver(this);
        this.featLoader.addObserver(this);
        this.languageLoader.addObserver(this);
        this.locationLoader.addObserver(this);
        this.classLoader.addObserver(this);
        this.paperLoader.addObserver(this);
        this.pointBuyLoader.addObserver(this);
        this.raceLoader.addObserver(this);
        this.schoolLoader.addObserver(this);
        this.sizeLoader.addObserver(this);
        this.skillLoader.addObserver(this);
        this.abilityLoader.addObserver(this);
        this.spellLoader.addObserver(this);
        this.statCheckLoader.addObserver(this);
        this.traitLoader.addObserver(this);
        this.unitLoader.addObserver(this);
        this.wProfLoader.addObserver(this);
    }

    public void setChosenCampaignSourcefiles(List l) {
        this.chosenCampaignSourcefiles.clear();
        this.chosenCampaignSourcefiles.addAll(l);
        SettingsHandler.getOptions().setProperty("pcgen.files.chosenCampaignSourcefiles", CoreUtility.join((Collection)this.chosenCampaignSourcefiles, ','));
    }

    public List getChosenCampaignSourcefiles() {
        return this.chosenCampaignSourcefiles;
    }

    public void setCurrentSource(String aString) {
        this.currentSource = aString;
    }

    public void setCustomItemsLoaded(boolean argLoaded) {
        this.customItemsLoaded = argLoaded;
    }

    public boolean isCustomItemsLoaded() {
        return this.customItemsLoaded;
    }

    public Set getSources() {
        return this.sourcesSet;
    }

    public void emptyLists() {
        this.loadedFiles.clear();
        this.chosenCampaignSourcefiles.clear();
        this.licensesToDisplayString = new StringBuffer();
        Globals.getBioSet().clearUserMap();
        this.releaseFileData();
        this.bioSet.clearUserMap();
        this.skillReq = "";
        this.customItemsLoaded = false;
    }

    public void initialize() throws PersistenceLayerException {
        this.loadGameModes();
        this.loadPCCFilesInDirectory(SettingsHandler.getPccFilesLocation().getAbsolutePath());
        this.loadPCCFilesInDirectory(SettingsHandler.getPcgenVendorDataDir().getAbsolutePath());
        this.campaignLoader.initRecursivePccFiles();
        String systemPrefix = SettingsHandler.getPcgenSystemDir() + File.separator;
        this.schoolLoader.loadLstFile(systemPrefix + "schools.lst");
        this.abilityLoader.loadLstFile(systemPrefix + "specials" + File.separator + "specials.lst");
        this.bonusLoader.loadLstFile(systemPrefix + "specials" + File.separator + "bonusstacks.lst");
        try {
            this.eqSlotLoader.loadLstFile(systemPrefix + "specials" + File.separator + "equipmentslots.lst", "*");
        }
        catch (PersistenceLayerException persistenceLayerException) {
            // empty catch block
        }
        this.sizeLoader.loadLstFile(systemPrefix + "sizeAdjustment.lst");
        this.paperLoader.loadLstFile(systemPrefix + "paperInfo.lst");
        this.traitLoader.loadLstFile(systemPrefix + "bio" + File.separator + "traits.lst");
        this.locationLoader.loadLstFile(systemPrefix + "bio" + File.separator + "locations.lst");
        this.bioLoader.loadLstFile(systemPrefix + "bio" + File.separator + "biosettings.lst");
        this.pointBuyLoader.loadLstFile(systemPrefix + "pointbuymethods.lst");
        this.unitLoader.loadLstFile(systemPrefix + "unitSet.lst");
        Globals.sortPObjectList(Globals.getCampaignList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCampaigns(List aSelectedCampaignsList) throws PersistenceLayerException {
        Globals.setSorted(false);
        this.sourcesSet.clear();
        this.licenseFiles.clear();
        if (aSelectedCampaignsList.size() == 0) {
            throw new PersistenceLayerException("You must select at least one campaign to load.");
        }
        try {
            if (SettingsHandler.getGame() == null) {
                return;
            }
            String modeFilePrefix = SettingsHandler.getPcgenSystemDir() + File.separator + "gameModes" + File.separator + SettingsHandler.getGame().getName() + File.separator;
            this.statCheckLoader.loadLstFile(modeFilePrefix + "statsandchecks.lst");
            this.sortCampaignsByRank(aSelectedCampaignsList);
            this.readPccFiles(aSelectedCampaignsList);
            this.addCustomFilesToStartOfList();
            this.setChanged();
            this.notifyObservers(new Integer(this.countTotalFilesToLoad()));
            this.wProfLoader.loadLstFiles(this.weaponProfFileList);
            this.skillLoader.loadLstFiles(this.skillFileList);
            this.languageLoader.loadLstFiles(this.languageFileList);
            this.featLoader.loadLstFiles(this.featFileList);
            this.raceLoader.loadLstFiles(this.raceFileList);
            this.classLoader.loadLstFiles(this.classFileList);
            this.domainLoader.loadLstFiles(this.domainFileList);
            this.deityLoader.loadLstFiles(this.deityFileList);
            this.spellLoader.loadLstFiles(this.spellFileList);
            this.currencyParser.loadLstFiles(this.coinFileList);
            for (int loadIdx = 0; loadIdx < loadOrder.length; ++loadIdx) {
                int lineType = loadOrder[loadIdx];
                List fileList = this.getFilesForType(lineType);
                if (fileList == null || fileList.isEmpty()) continue;
                ArrayList bArrayList = new ArrayList();
                this.processFileList(lineType, fileList, bArrayList);
            }
            this.bioLoader.loadLstFiles(this.bioSetFileList);
            this.checkRequiredSkills();
            this.checkRequiredDeities();
            this.addDefaultEquipmentMods();
            this.loadCustomItems();
            this.checkRaceTypes();
            this.verifyWeaponsMeleeOrRanged();
            if (!SettingsHandler.wantToLoadMasterworkAndMagic()) {
                EquipmentList.autoGenerateEquipment();
            }
            PObjectLoader.finishFeatProcessing();
            this.showLicensesIfNeeded();
        }
        finally {
            this.releaseFileData();
            this.setChanged();
            this.notifyObservers("DONE");
        }
    }

    private int countTotalFilesToLoad() {
        int count = this.bioSetFileList.size();
        count += this.classFileList.size();
        count += this.classSkillFileList.size();
        count += this.classSpellFileList.size();
        count += this.coinFileList.size();
        count += this.companionmodFileList.size();
        count += this.deityFileList.size();
        count += this.domainFileList.size();
        count += this.equipmentFileList.size();
        count += this.equipmodFileList.size();
        count += this.featFileList.size();
        count += this.kitFileList.size();
        count += this.languageFileList.size();
        count += this.pccFileList.size();
        count += this.raceFileList.size();
        count += this.reqSkillFileList.size();
        count += this.skillFileList.size();
        count += this.spellFileList.size();
        count += this.templateFileList.size();
        return count += this.weaponProfFileList.size();
    }

    public void loadFileIntoList(String fileName, int fileType, List aList) throws PersistenceLayerException {
        URL url = null;
        String urlString = "";
        try {
            urlString = CoreUtility.fileToURL(fileName);
            url = new URL(fileName);
        }
        catch (MalformedURLException e) {
            try {
                this.setChanged();
                this.notifyObservers("Unable to convert '" + urlString + "' to a URL");
                url = new URL("http://g");
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
        this.setChanged();
        this.notifyObservers(url);
        this.initFile(fileName, fileType, aList, true);
    }

    public void loadModItems(boolean flagDisplayError) {
        String aString;
        PObject anObj;
        int i;
        if (this.modLines.size() > 0) {
            i = 0;
            block16: while (i < this.modLines.size()) {
                anObj = null;
                StringTokenizer aTok = new StringTokenizer(this.modLines.get(i).toString(), "\t");
                aString = aTok.nextToken();
                aTok = new StringTokenizer(aString, ":");
                aTok.nextToken();
                if (aTok.countTokens() > 0) {
                    aString = aTok.nextToken();
                }
                aString = aString.substring(0, aString.indexOf(".MOD"));
                try {
                    switch (Integer.valueOf(this.modFileType.get(i).toString())) {
                        case -1: {
                            ++i;
                            continue block16;
                        }
                        case 25: {
                            anObj = Globals.getCompanionMod(aString);
                            CompanionModLoader.parseLine(anObj, this.modLines.get(i).toString(), null, 0);
                            this.modLines.remove(i);
                            this.modFileType.remove(i);
                            break;
                        }
                        case 9: {
                            anObj = EquipmentList.getEquipmentNamed(aString);
                            EquipmentLoader.parseLine((Equipment)anObj, this.modLines.get(i).toString(), null, 0);
                            this.modLines.remove(i);
                            this.modFileType.remove(i);
                            break;
                        }
                        case 17: {
                            anObj = Globals.getTemplateNamed(aString);
                            PCTemplateLoader.parseLine((PCTemplate)anObj, this.modLines.get(i).toString(), null, 0);
                            this.modLines.remove(i);
                            this.modFileType.remove(i);
                            break;
                        }
                        default: {
                            this.logError("In LstSystemLoader.loadMod the fileType " + this.modFileType.get(i).toString() + " is not handled.");
                            break;
                        }
                    }
                }
                catch (PersistenceLayerException ple) {
                    this.logError("PersistenceLayerException in LstSystemLoader.loadMod. ", ple);
                }
                catch (NullPointerException npe) {
                    this.logError("Null pointer exception in LstSystemLoader.loadMod. ", npe);
                }
                if (anObj != null) continue;
                if (flagDisplayError) {
                    this.logError("Cannot apply .MOD: " + aString + " not found");
                }
                ++i;
            }
        }
        if (this.forgetLines.size() > 0) {
            for (i = 0; i < this.forgetLines.size(); ++i) {
                aString = this.forgetLines.get(i).toString();
                try {
                    switch (Integer.valueOf(this.forgetFileType.get(i).toString())) {
                        case 25: {
                            anObj = Globals.getCompanionMod(aString);
                            Globals.getCompanionModList().remove(anObj);
                            break;
                        }
                        case 9: {
                            anObj = EquipmentList.getEquipmentNamed(aString);
                            EquipmentList.getEquipmentList().remove(anObj);
                            break;
                        }
                        case 17: {
                            anObj = Globals.getTemplateNamed(aString);
                            Globals.getTemplateList().remove(anObj);
                            break;
                        }
                        default: {
                            this.logError("In LstSystemLoader.loadMod the fileType " + this.modFileType.get(i).toString() + " cannot be forgotten.");
                            break;
                        }
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    this.logError("Null pointer exception in LstSystemLoader.loadMod. ", e);
                }
            }
            this.forgetLines.clear();
            this.forgetFileType.clear();
        }
    }

    public void refreshCampaigns() {
        Globals.clearCampaignsForRefresh();
        this.loadPCCFilesInDirectory(SettingsHandler.getPccFilesLocation().getAbsolutePath());
        this.loadPCCFilesInDirectory(SettingsHandler.getPcgenVendorDataDir().getAbsolutePath());
    }

    private static void setCampaignOptions(Campaign aCamp) {
        Properties options = aCamp.getOptions();
        if (options != null) {
            Enumeration<?> e = options.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = options.getProperty(key);
                SettingsHandler.setPCGenOption(key, value);
            }
        }
    }

    private List getFilesForType(int lineType) {
        List lineList = null;
        switch (lineType) {
            case 25: {
                lineList = this.companionmodFileList;
                break;
            }
            case 9: {
                lineList = this.equipmentFileList;
                break;
            }
            case 11: {
                break;
            }
            case 14: {
                lineList = this.classSkillFileList;
                break;
            }
            case 15: {
                lineList = this.classSpellFileList;
                break;
            }
            case 16: {
                lineList = this.reqSkillFileList;
                break;
            }
            case 17: {
                lineList = this.templateFileList;
                break;
            }
            case 19: {
                lineList = this.equipmodFileList;
                break;
            }
            case 30: {
                lineList = this.kitFileList;
                break;
            }
            default: {
                this.logError("Campaign list corrupt; no such lineType (" + lineType + ") exists. Stopped parsing campaigns, but not aborting program.");
            }
        }
        return lineList;
    }

    private static String[] getGameFilesList() {
        String aDirectory = SettingsHandler.getPcgenSystemDir() + File.separator + "gameModes" + File.separator;
        return new File(aDirectory).list(gameModeFileFilter);
    }

    private void addCustomFilesToStartOfList() {
        String tempGame;
        CampaignSourceEntry tempSource = null;
        Campaign customCampaign = new Campaign();
        customCampaign.setName("Custom");
        customCampaign.setDescription("Custom data");
        if (new File(CustomData.customBioSetFilePath(true)).exists()) {
            tempGame = CustomData.customBioSetFilePath(true);
            this.bioSetFileList.remove(tempGame);
            this.bioSetFileList.add(0, tempGame);
        }
        if (new File(CustomData.customClassFilePath(true)).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, CustomData.customClassFilePath(true));
            this.classFileList.remove(tempSource);
            this.classFileList.add(0, tempSource);
        }
        if (new File(CustomData.customDeityFilePath(true)).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, CustomData.customDeityFilePath(true));
            this.deityFileList.remove(tempSource);
            this.deityFileList.add(0, tempSource);
        }
        if (new File(CustomData.customDomainFilePath(true)).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, CustomData.customDomainFilePath(true));
            this.domainFileList.remove(tempSource);
            this.domainFileList.add(0, tempSource);
        }
        if (new File(CustomData.customFeatFilePath(true)).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, CustomData.customFeatFilePath(true));
            this.featFileList.remove(tempSource);
            this.featFileList.add(0, tempSource);
        }
        if (new File(CustomData.customLanguageFilePath(true)).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, CustomData.customLanguageFilePath(true));
            this.languageFileList.remove(tempSource);
            this.languageFileList.add(0, tempSource);
        }
        if (new File(CustomData.customRaceFilePath(true)).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, CustomData.customRaceFilePath(true));
            this.raceFileList.remove(tempSource);
            this.raceFileList.add(0, tempSource);
        }
        if (new File(CustomData.customSkillFilePath(true)).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, CustomData.customSkillFilePath(true));
            this.skillFileList.remove(tempSource);
            this.skillFileList.add(0, tempSource);
        }
        if (new File(CustomData.customSpellFilePath(true)).exists()) {
            tempSource = new CampaignSourceEntry(customCampaign, CustomData.customSpellFilePath(true));
            this.spellFileList.remove(tempSource);
            this.spellFileList.add(0, tempSource);
        }
        if (new File(CustomData.customTemplateFilePath(true)).exists()) {
            tempGame = CustomData.customTemplateFilePath(true);
            this.templateFileList.remove(tempGame);
            this.templateFileList.add(0, tempGame);
        }
    }

    private void addDefaultEquipmentMods() throws PersistenceLayerException {
        EquipmentModifier anObj = new EquipmentModifier();
        String aLine = "Add Type\tKEY:ADDTYPE\tTYPE:ALL\tCOST:0\tNAMEOPT:NONAME\tSOURCE:PCGen Internal\tCHOOSE:COUNT=ALL|desired TYPE(s)|TYPE=EQTYPES";
        EquipmentModifierLoader.parseLine(anObj, aLine, null, -1);
        EquipmentList.getModifierList().add(anObj);
        anObj = new EquipmentModifier();
        aLine = "PCGENi_WEAPON\tTYPE:Weapon\tVISIBLE:No\tCHOOSE:DUMMY\tNAMEOPT:NONAME";
        EquipmentModifierLoader.parseLine(anObj, aLine, null, -1);
        EquipmentList.getModifierList().add(anObj);
        anObj = new EquipmentModifier();
        aLine = "PCGENi_ARMOR\tTYPE:Armor\tVISIBLE:No\tCHOOSE:DUMMY\tNAMEOPT:NONAME";
        EquipmentModifierLoader.parseLine(anObj, aLine, null, -1);
        EquipmentList.getModifierList().add(anObj);
    }

    private void addToGlobals(int lineType, List aArrayList) {
        String aClassName = "";
        block11: for (int i = 0; i < aArrayList.size(); ++i) {
            switch (lineType) {
                case 25: {
                    CompanionMod cMod = Globals.getCompanionMod(((CompanionMod)aArrayList.get(i)).getKeyName());
                    if (cMod != null) continue block11;
                    Globals.getCompanionModList().add(aArrayList.get(i));
                    continue block11;
                }
                case 9: {
                    Equipment eq = EquipmentList.getEquipmentKeyed(((Equipment)aArrayList.get(i)).getKeyName());
                    if (eq != null) continue block11;
                    EquipmentList.getEquipmentList().add(aArrayList.get(i));
                    continue block11;
                }
                case 14: {
                    LstSystemLoader.parseClassSkillFrom((String)aArrayList.get(i));
                    continue block11;
                }
                case 15: {
                    aClassName = LstSystemLoader.parseClassSpellFrom((String)aArrayList.get(i), aClassName);
                    continue block11;
                }
                case 16: {
                    String aString = (String)aArrayList.get(i);
                    if ("ALL".equals(aString) || "UNTRAINED".equals(aString)) {
                        this.skillReq = aString;
                        continue block11;
                    }
                    Skill skillKeyed = Globals.getSkillKeyed(aString);
                    if (skillKeyed == null) continue block11;
                    skillKeyed.setRequired(true);
                    continue block11;
                }
                case 17: {
                    PCTemplate aTemplate = Globals.getTemplateKeyed(((PCTemplate)aArrayList.get(i)).getKeyName());
                    if (aTemplate != null) continue block11;
                    Globals.getTemplateList().add(aArrayList.get(i));
                    continue block11;
                }
                case 19: {
                    EquipmentModifier aModifier = EquipmentList.getModifierKeyed(((EquipmentModifier)aArrayList.get(i)).getKeyName());
                    if (aModifier != null) continue block11;
                    EquipmentList.getModifierList().add(aArrayList.get(i));
                    continue block11;
                }
                case 30: {
                    continue block11;
                }
                case -1: {
                    continue block11;
                }
                default: {
                    this.logError("In LstSystemLoader.initValue the lineType " + lineType + " is not handled.");
                }
            }
        }
        aArrayList.clear();
    }

    private void checkRaceTypes() {
        Iterator e2 = Globals.getRaceMap().values().iterator();
        while (e2.hasNext()) {
            Race aRace = (Race)e2.next();
            if (aRace.getMyTypeCount() != 0) continue;
            this.logError("Race " + aRace.getName() + " has no type. Assuming Humanoid.");
            aRace.setTypeInfo("HUMANOID");
        }
    }

    private void checkRequiredDeities() throws PersistenceLayerException {
        List gDeities = Globals.getGlobalDeityList();
        if (gDeities != null && gDeities.size() != 0) {
            this.deityLoader.loadLstFile(this.globalCampaign);
            Iterator e = gDeities.iterator();
            while (e.hasNext()) {
                String aLine = (String)e.next();
                Deity aDeity = (Deity)this.deityLoader.parseLine(null, aLine, this.globalCampaign);
                this.deityLoader.finishObject(aDeity);
            }
        }
    }

    private void checkRequiredSkills() {
        if (this.skillReq.length() > 0) {
            Iterator e1 = Globals.getSkillList().iterator();
            while (e1.hasNext()) {
                Skill aSkill = (Skill)e1.next();
                if ((!"UNTRAINED".equals(this.skillReq) || aSkill.getUntrained().length() <= 0 || aSkill.getUntrained().charAt(0) != 'Y') && !this.skillReq.equals("ALL")) continue;
                aSkill.setRequired(true);
            }
        }
    }

    private int countCloseParens(String token) {
        String dString = token;
        int parenCount = 0;
        while (dString.lastIndexOf(41) >= 0) {
            ++parenCount;
            dString = dString.substring(0, dString.lastIndexOf(41));
        }
        return parenCount;
    }

    private int countOpenParens(String token) {
        String dString = token;
        int parenCount = 0;
        while (dString.lastIndexOf(40) >= 0) {
            ++parenCount;
            dString = dString.substring(0, dString.lastIndexOf(40));
        }
        return parenCount;
    }

    private void initFile(String argFileName, int fileType, List aList, boolean throwException) throws PersistenceLayerException {
        StringBuffer dataBuffer = new StringBuffer();
        if (this.lstExcludeFiles.contains(argFileName)) {
            return;
        }
        URL aURL = LstFileLoader.readFileGetURL(argFileName, dataBuffer);
        if (aURL == null) {
            return;
        }
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        String newlinedelim = "\r\n";
        String aString = dataBuffer.toString();
        StringTokenizer newlineStr = new StringTokenizer(aString, "\r\n");
        this.setCurrentSource("");
        String nameString = "";
        String aLine = "";
        String prevLine = "";
        Campaign sourceCampaign = null;
        PObject anObj = null;
        block13: while (newlineStr.hasMoreTokens()) {
            boolean isForgetItem;
            aLine = newlineStr.nextToken();
            ++lineNum;
            if (aLine.startsWith("CAMPAIGN:") && fileType != 13) {
                sourceCampaign = Globals.getCampaignNamed(aLine.substring(9));
                continue;
            }
            if (aLine.length() == 0 || fileType != 13 && aLine.length() > 0 && aLine.charAt(0) == '#') continue;
            if (aLine.startsWith("SOURCE") && fileType != 13) {
                StringTokenizer sTok = new StringTokenizer(aLine, "|");
                while (sTok.hasMoreTokens()) {
                    String arg = sTok.nextToken();
                    String key = arg.substring(6, arg.indexOf(":"));
                    String val = arg.substring(arg.indexOf(":") + 1);
                    sourceMap.put(key, val);
                }
                continue;
            }
            String copyName = null;
            boolean isModItem = aLine.endsWith(".MOD");
            if (isModItem && aLine.startsWith("CLASS:")) {
                nameString = aLine.substring(0, aLine.length() - 4);
            }
            if (isForgetItem = aLine.endsWith(".FORGET")) {
                nameString = aLine.substring(0, aLine.length() - 7);
            }
            if (aLine.indexOf(9) > 2) {
                StringTokenizer t = new StringTokenizer(aLine, "\t");
                nameString = t.nextToken();
                isModItem = nameString.endsWith(".MOD");
                if (isModItem) {
                    nameString = nameString.substring(0, nameString.length() - 4);
                } else if (nameString.indexOf(".COPY=") > 0) {
                    copyName = nameString.substring(nameString.indexOf(".COPY=") + 6);
                    nameString = nameString.substring(0, nameString.indexOf(".COPY="));
                }
            }
            switch (fileType) {
                case 25: {
                    anObj = this.initFileTypeCompanionMod(isForgetItem, nameString, fileType, isModItem, anObj, sourceCampaign, sourceMap, aList, aLine, aURL);
                    break;
                }
                case 9: {
                    anObj = this.initFileTypeEquipment(isForgetItem, nameString, fileType, isModItem, copyName, anObj, sourceCampaign, sourceMap, aList, aLine, aURL);
                    break;
                }
                case 11: {
                    Globals.getLoadStrings().add(aLine);
                    break;
                }
                case -1: 
                case 14: 
                case 15: 
                case 16: {
                    aList.add(aLine);
                    break;
                }
                case 17: {
                    anObj = this.initFileTypeTemplate(isForgetItem, nameString, fileType, isModItem, anObj, sourceCampaign, sourceMap, aList, aLine, aURL);
                    break;
                }
                case 19: {
                    anObj = LstSystemLoader.initFileTypeEqModifier(sourceCampaign, sourceMap, aLine, aURL, aList);
                    break;
                }
                case 30: {
                    if (aLine.startsWith("REGION:")) {
                        prevLine = aLine.substring(7);
                        continue block13;
                    }
                    if (prevLine.length() == 0) {
                        throw new PersistenceLayerException("Illegal kit info " + aURL.toString() + ":" + Integer.toString(lineNum) + " \"" + aLine + "\"");
                    }
                    if (aLine.startsWith("STARTPACK:")) {
                        anObj = new Kit(prevLine);
                        anObj.setSourceCampaign(sourceCampaign);
                        anObj.setSourceMap(sourceMap);
                        Globals.getKitInfo().add(anObj);
                    }
                    if (anObj == null) break;
                    KitLoader.parseLine((Kit)anObj, aLine, aURL, lineNum);
                    break;
                }
                default: {
                    this.logError("In LstSystemLoader.initValue the fileType " + fileType + " is not handled.");
                }
            }
            switch (fileType) {
                case 9: 
                case 19: 
                case 30: {
                    if (anObj == null) continue block13;
                    anObj.setSourceFile(aURL.toString());
                    continue block13;
                }
                case -1: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 22: 
                case 25: {
                    continue block13;
                }
            }
            this.logError("In LstSystemLoader.initValue the fileType " + fileType + " is not handled.");
        }
        this.setCurrentSource("");
    }

    private static PObject initFileTypeEqModifier(Campaign sourceCampaign, Map sourceMap, String aLine, URL aURL, List aList) throws PersistenceLayerException {
        EquipmentModifier anObj = new EquipmentModifier();
        anObj.setSourceCampaign(sourceCampaign);
        anObj.setSourceMap(sourceMap);
        EquipmentModifierLoader.parseLine(anObj, aLine, aURL, lineNum);
        aList.add(anObj);
        return anObj;
    }

    private PObject initFileTypeCompanionMod(boolean forgetItem, String nameString, int fileType, boolean modItem, PObject anObj, Campaign sourceCampaign, Map sourceMap, List aList, String aLine, URL aURL) {
        if (forgetItem) {
            this.forgetItem(Globals.getCompanionMod(nameString), nameString, fileType);
            return anObj;
        }
        if (!modItem) {
            anObj = new CompanionMod();
            anObj.setSourceCampaign(sourceCampaign);
            anObj.setSourceMap(sourceMap);
            aList.add(anObj);
        } else {
            anObj = Globals.getCompanionMod(nameString);
        }
        if (anObj == null) {
            this.modLines.add(aLine);
            this.modFileType.add(new Integer(fileType));
        }
        if (anObj != null) {
            try {
                CompanionModLoader.parseLine((CompanionMod)anObj, aLine, aURL, lineNum);
            }
            catch (PersistenceLayerException ple) {
                this.logError("Unable to parse the companion modifiers file: '" + aURL + "':'" + aLine + "' " + ple.getMessage());
            }
        }
        return anObj;
    }

    private PObject initFileTypeEquipment(boolean forgetItem, String nameString, int fileType, boolean modItem, String copyName, PObject anObj, Campaign sourceCampaign, Map sourceMap, List aList, String aLine, URL aURL) throws PersistenceLayerException {
        if (forgetItem) {
            this.forgetItem(EquipmentList.getEquipmentNamed(nameString), nameString, fileType);
            return anObj;
        }
        if (!modItem) {
            if (copyName == null) {
                anObj = new Equipment();
                anObj.setSourceCampaign(sourceCampaign);
                anObj.setSourceMap(sourceMap);
            } else {
                anObj = EquipmentList.getEquipmentNamed(nameString);
                if (anObj != null) {
                    try {
                        anObj = (PObject)anObj.clone();
                    }
                    catch (CloneNotSupportedException exc) {
                        ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.ERROR);
                    }
                    anObj.setName(copyName);
                } else {
                    this.logError("Could not copy " + nameString + " to create " + copyName);
                }
            }
            if (anObj != null) {
                aList.add(anObj);
            }
        } else {
            anObj = EquipmentList.getEquipmentNamed(nameString);
            if (anObj == null) {
                anObj = EquipmentList.getEquipmentNamed(nameString, aList);
            }
        }
        if (modItem && anObj == null) {
            this.modLines.add(aLine);
            this.modFileType.add(new Integer(fileType));
        }
        if (anObj != null) {
            EquipmentLoader.parseLine((Equipment)anObj, aLine, aURL, lineNum);
        }
        return anObj;
    }

    private PObject initFileTypeTemplate(boolean forgetItem, String nameString, int fileType, boolean modItem, PObject anObj, Campaign sourceCampaign, Map sourceMap, List aList, String aLine, URL aURL) throws PersistenceLayerException {
        if (forgetItem) {
            this.forgetItem(Globals.getTemplateNamed(nameString), nameString, fileType);
            return anObj;
        }
        if (!modItem) {
            anObj = new PCTemplate();
            anObj.setSourceCampaign(sourceCampaign);
            anObj.setSourceMap(sourceMap);
            aList.add(anObj);
        } else {
            anObj = Globals.getTemplateNamed(nameString);
        }
        if (anObj == null) {
            this.modLines.add(aLine);
            this.modFileType.add(new Integer(fileType));
        }
        if (anObj != null) {
            PCTemplateLoader.parseLine((PCTemplate)anObj, aLine, aURL, lineNum);
        }
        return anObj;
    }

    private void loadCampaignFile(Campaign aCamp) throws PersistenceLayerException {
        aCamp.setIsLoaded(true);
        String sourceFile = aCamp.getSourceFile();
        if (!this.chosenCampaignSourcefiles.contains(sourceFile)) {
            this.chosenCampaignSourcefiles.add(sourceFile);
            SettingsHandler.getOptions().setProperty("pcgen.files.chosenCampaignSourcefiles", CoreUtility.join((Collection)this.chosenCampaignSourcefiles, ','));
        }
        this.showOGL |= aCamp.isOGL();
        this.showD20 |= aCamp.isD20();
        this.showLicensed |= aCamp.isLicensed();
        if (aCamp.isLicensed()) {
            this.licensesToDisplayString.append(aCamp.getLicense());
            this.licenseFiles.addAll(aCamp.getLicenseFiles());
        }
        this.lstExcludeFiles.addAll(aCamp.getLstExcludeFiles());
        this.raceFileList.addAll(aCamp.getRaceFileList());
        this.classFileList.addAll(aCamp.getClassFileList());
        this.companionmodFileList.addAll(aCamp.getCompanionmodFileList());
        this.skillFileList.addAll(aCamp.getSkillFileList());
        this.featFileList.addAll(aCamp.getFeatFileList());
        this.deityFileList.addAll(aCamp.getDeityFileList());
        this.domainFileList.addAll(aCamp.getDomainFileList());
        this.weaponProfFileList.addAll(aCamp.getWeaponProfFileList());
        this.equipmentFileList.addAll(aCamp.getEquipmentFileList());
        this.classSkillFileList.addAll(aCamp.getClassSkillFileList());
        this.classSpellFileList.addAll(aCamp.getClassSpellFileList());
        this.spellFileList.addAll(aCamp.getSpellFileList());
        this.languageFileList.addAll(aCamp.getLanguageFileList());
        this.reqSkillFileList.addAll(aCamp.getReqSkillFileList());
        this.templateFileList.addAll(aCamp.getTemplateFileList());
        this.equipmodFileList.addAll(aCamp.getEquipmodFileList());
        this.coinFileList.addAll(aCamp.getCoinFileList());
        this.kitFileList.addAll(aCamp.getKitFileList());
        this.bioSetFileList.addAll(aCamp.getBioSetFileList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadCustomItems() {
        block13: {
            String aLine;
            this.customItemsLoaded = true;
            if (!SettingsHandler.getSaveCustomEquipment()) {
                return;
            }
            BufferedReader br = CustomData.getCustomEquipmentReader();
            EquipmentList.setAutoGeneration(true);
            while (br != null && (aLine = br.readLine()) != null) {
                int idx;
                if (!aLine.startsWith("BASEITEM:") || (idx = aLine.indexOf(9, 9)) < 10) continue;
                String baseItemKey = aLine.substring(9, idx);
                aLine = aLine.substring(idx + 1);
                Equipment aEq = EquipmentList.getEquipmentKeyed(baseItemKey);
                if (aEq == null) continue;
                aEq = (Equipment)aEq.clone();
                aEq.load(aLine);
                EquipmentList.addEquipment(aEq);
            }
            Object var7_7 = null;
            EquipmentList.setAutoGeneration(false);
            Globals.sortPObjectList(EquipmentList.getEquipmentList());
            try {
                if (br != null) {
                    br.close();
                }
                break block13;
            }
            catch (IOException ex) {
                this.logError("Error when closing infile after loading custom items", ex);
            }
            break block13;
            {
                catch (IOException e) {
                    this.logError("Error when loading custom items", e);
                    Object var7_8 = null;
                    EquipmentList.setAutoGeneration(false);
                    Globals.sortPObjectList(EquipmentList.getEquipmentList());
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block13;
                    }
                    catch (IOException ex) {
                        this.logError("Error when closing infile after loading custom items", ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                EquipmentList.setAutoGeneration(false);
                Globals.sortPObjectList(EquipmentList.getEquipmentList());
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    this.logError("Error when closing infile after loading custom items", ex);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadGameModeInfoFile(GameMode gameMode, File aFile, String aType) {
        block14: {
            String aLine;
            BufferedReader br = null;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(aFile), "UTF-8"));
            int lineNum = 0;
            while ((aLine = br.readLine()) != null) {
                ++lineNum;
                if (aLine.length() > 0 && aLine.charAt(0) == '#' || aLine.length() == 0) continue;
                if (aType.equals("load")) {
                    gameMode.addLoadString(aLine);
                    continue;
                }
                if (aType.equals("level")) {
                    LevelInfo level = new LevelInfo();
                    LevelLoader.parseLine(level, aLine, lineNum);
                    gameMode.addLevelInfo(level);
                    continue;
                }
                if (!aType.equals("rules")) continue;
                RuleCheckLoader.parseLine(gameMode, aLine);
            }
            Object var8_8 = null;
            try {
                if (br != null) {
                    br.close();
                }
                break block14;
            }
            catch (IOException ex2) {
                Logging.errorPrint("Error when trying to close after loading game mode " + aType + " info", ex2);
            }
            break block14;
            {
                catch (IOException ex) {
                    Logging.errorPrint("Error when loading game mode " + aType + " info", ex);
                    Object var8_9 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block14;
                    }
                    catch (IOException ex2) {
                        Logging.errorPrint("Error when trying to close after loading game mode " + aType + " info", ex2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex2) {
                    Logging.errorPrint("Error when trying to close after loading game mode " + aType + " info", ex2);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static GameMode loadGameModeMiscInfo(String aName, File aFile) {
        GameMode gameMode;
        block16: {
            String aLine;
            gameMode = null;
            BufferedReader br = null;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(aFile), "UTF-8"));
            while ((aLine = br.readLine()) != null) {
                if (aLine.length() > 0 && aLine.charAt(0) == '#' || aLine.length() == 0) continue;
                if (gameMode == null) {
                    gameMode = new GameMode(aName);
                    SystemCollections.addToGameModeList(gameMode);
                }
                GameModeLoader.parseMiscGameInfoLine(gameMode, aLine, aFile, lineNum);
            }
            Object var6_7 = null;
            try {
                if (br != null) {
                    br.close();
                }
                break block16;
            }
            catch (IOException ex2) {
                Logging.errorPrint("Error when trying to clase file after loading game mode misc info", ex2);
            }
            break block16;
            {
                catch (IOException ex) {
                    Logging.errorPrint("Error when loading game mode misc info", ex);
                    Object var6_8 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block16;
                    }
                    catch (IOException ex2) {
                        Logging.errorPrint("Error when trying to clase file after loading game mode misc info", ex2);
                    }
                    break block16;
                }
                catch (PersistenceLayerException ple) {
                    Logging.errorPrint("Error when loading game mode misc info: " + ple.getMessage());
                    Object var6_9 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block16;
                    }
                    catch (IOException ex2) {
                        Logging.errorPrint("Error when trying to clase file after loading game mode misc info", ex2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex2) {
                    Logging.errorPrint("Error when trying to clase file after loading game mode misc info", ex2);
                }
                throw throwable;
            }
        }
        return gameMode;
    }

    private void loadPCCFilesInDirectory(String aDirectory) {
        new File(aDirectory).list(this.pccFileFilter);
    }

    private static void parseClassSkillFrom(String aLine) {
        StringTokenizer aTok = new StringTokenizer(aLine, "\t");
        String className = aTok.nextToken();
        PCClass aClass = Globals.getClassKeyed(className);
        String aName = className;
        if (aClass != null) {
            aName = aClass.getKeyName();
        }
        if (aTok.hasMoreTokens()) {
            className = aTok.nextToken();
            aTok = new StringTokenizer(className, "|");
            while (aTok.hasMoreTokens()) {
                String aString = aTok.nextToken();
                String aStringParen = aString + "(";
                Skill aSkill = Globals.getSkillKeyed(aString);
                if (aSkill != null) {
                    aSkill.getClassList().add(aName);
                    continue;
                }
                Iterator e = Globals.getSkillList().iterator();
                while (e.hasNext()) {
                    Skill bSkill = (Skill)e.next();
                    if (!bSkill.getKeyName().startsWith(aStringParen)) continue;
                    bSkill.getClassList().add(aName);
                }
            }
        }
    }

    private static String parseClassSpellFrom(String aLine, String aName) {
        StringTokenizer aTok = new StringTokenizer(aLine, "\t");
        String aString = aTok.nextToken();
        if (aString.startsWith("DOMAIN:")) {
            aName = aString.substring(7);
            Domain aDom = Globals.getDomainKeyed(aName);
            aName = aDom != null ? "DOMAIN|" + aName : "";
        }
        if (aString.startsWith("CLASS:")) {
            PObject aClass;
            boolean isClass = true;
            aName = "";
            if (aString.length() > 6) {
                aName = aString.substring(6);
            }
            if ((aClass = Globals.getClassKeyed(aName)) != null && ((PCClass)aClass).getSpellType().equalsIgnoreCase("None")) {
                aClass = null;
            }
            if (aClass == null && (aClass = Globals.getDomainKeyed(aName)) != null) {
                isClass = false;
            }
            if (aClass != null) {
                aName = aClass.getKeyName();
            }
            aName = isClass ? "CLASS|" + aName : "DOMAIN|" + aName;
        } else if (aTok.hasMoreTokens()) {
            PObject aClass;
            String name = aName.substring(aName.indexOf(124) + 1);
            if (aName.startsWith("DOMAIN|")) {
                aClass = Globals.getDomainNamed(name);
            } else if (aName.startsWith("CLASS|")) {
                aClass = Globals.getClassNamed(name);
            } else {
                return aName;
            }
            if (aClass == null) {
                Iterator i = pList.iterator();
                while (i.hasNext() && !(aClass = (PObject)i.next()).getName().equals(name)) {
                    aClass = null;
                }
                if (aClass == null) {
                    aClass = new PObject();
                    aClass.setName(name);
                    pList.add(aClass);
                }
            }
            int level = Integer.parseInt(aString);
            String bString = aTok.nextToken();
            aTok = new StringTokenizer(bString, "|");
            while (aTok.hasMoreTokens()) {
                Spell aSpell = Globals.getSpellKeyed(aTok.nextToken().trim());
                if (aSpell == null) continue;
                aSpell.setLevelInfo(aName, level);
            }
        }
        return aName;
    }

    private void forgetItem(PObject itemToForget, String nameOfItemToForget, int fileType) {
        if (itemToForget == null) {
            this.logError("Forgetting " + nameOfItemToForget + ": Not defined yet");
        }
        this.forgetLines.add(nameOfItemToForget);
        this.forgetFileType.add(new Integer(fileType));
    }

    private void loadGameModes() {
        String[] gameFiles = LstSystemLoader.getGameFilesList();
        if (gameFiles == null || gameFiles.length == 0) {
            return;
        }
        SystemCollections.clearGameModeList();
        String aDirectory = SettingsHandler.getPcgenSystemDir() + File.separator + "gameModes" + File.separator;
        for (int i = 0; i < gameFiles.length; ++i) {
            GameMode gm = LstSystemLoader.loadGameModeMiscInfo(gameFiles[i], new File(aDirectory + gameFiles[i] + File.separator + "miscinfo.lst"));
            SettingsHandler.setGame(gameFiles[i]);
            if (gm == null) continue;
            LstSystemLoader.loadGameModeInfoFile(gm, new File(aDirectory + gameFiles[i] + File.separator + "load.lst"), "load");
            LstSystemLoader.loadGameModeInfoFile(gm, new File(aDirectory + gameFiles[i] + File.separator + "level.lst"), "level");
            LstSystemLoader.loadGameModeInfoFile(gm, new File(aDirectory + gameFiles[i] + File.separator + "rules.lst"), "rules");
            try {
                this.eqSlotLoader.loadLstFile(aDirectory + gameFiles[i] + File.separator + "equipmentslots.lst", gameFiles[i]);
            }
            catch (PersistenceLayerException ple) {
                // empty catch block
            }
            try {
                this.statCheckLoader.loadLstFile(aDirectory + gameFiles[i] + File.separator + "statsandchecks.lst");
                continue;
            }
            catch (PersistenceLayerException ex) {
                // empty catch block
            }
        }
        SystemCollections.sortGameModeList();
    }

    private void processExtraInfo(int lineType, List pObjectList, String extraInfo) {
        StringTokenizer infoTokenizer = new StringTokenizer(extraInfo, "|");
        int inMode = 0;
        ArrayList<String> includeExcludeNames = new ArrayList<String>();
        while (infoTokenizer.hasMoreTokens()) {
            String name;
            String currentToken = infoTokenizer.nextToken();
            int openParens = this.countOpenParens(currentToken);
            int closeParens = this.countCloseParens(currentToken);
            boolean handled = false;
            if (currentToken.startsWith("(EXCLUDE")) {
                name = currentToken.substring(9);
                if (name.endsWith(")")) {
                    name = name.substring(0, name.length() - 1);
                }
                includeExcludeNames.add(name);
                inMode = -1;
                handled = true;
            } else if (currentToken.startsWith("(INCLUDE")) {
                name = currentToken.substring(9);
                if (name.endsWith(")")) {
                    name = name.substring(0, name.length() - 1);
                }
                includeExcludeNames.add(name);
                inMode = 1;
                handled = true;
            }
            if (currentToken.endsWith(")") && closeParens > openParens) {
                PObject anObject;
                int k;
                if (!handled) {
                    includeExcludeNames.add(currentToken.substring(0, currentToken.length() - 1));
                }
                if (inMode == -1) {
                    for (k = pObjectList.size() - 1; k >= 0; --k) {
                        anObject = (PObject)pObjectList.get(k);
                        if (!includeExcludeNames.contains(anObject.getKeyName())) continue;
                        pObjectList.remove(k);
                    }
                } else if (inMode == 1) {
                    for (k = pObjectList.size() - 1; k >= 0; --k) {
                        anObject = (PObject)pObjectList.get(k);
                        if (includeExcludeNames.contains(anObject.getKeyName())) continue;
                        pObjectList.remove(k);
                    }
                }
                handled = true;
                inMode = 0;
            }
            if (handled) continue;
            if (lineType != 12 && lineType != 16) {
                includeExcludeNames.add(currentToken);
                continue;
            }
            pObjectList.add(currentToken);
        }
    }

    private void processFileList(int lineType, List lineList, List bArrayList) throws PersistenceLayerException {
        if (lineType == 13) {
            this.logError("No longer processing campaigns in processFileList.");
            return;
        }
        for (int j = 0; j < lineList.size(); ++j) {
            Object o = lineList.get(j);
            String aLine = o instanceof String ? (String)o : ((CampaignSourceEntry)o).getFile();
            StringTokenizer lineTokenizer = new StringTokenizer(aLine, "|");
            String extraInfo = null;
            if (!lineTokenizer.hasMoreTokens()) continue;
            String fileName = lineTokenizer.nextToken();
            if (fileName.length() < aLine.length()) {
                extraInfo = aLine.substring(fileName.length());
            }
            if (this.loadedFiles.containsKey(fileName)) continue;
            this.loadFileIntoList(fileName, lineType, bArrayList);
            if (extraInfo != null) {
                this.processExtraInfo(lineType, bArrayList, extraInfo);
            } else {
                this.loadedFiles.put(fileName, fileName);
            }
            if (bArrayList.isEmpty()) continue;
            this.addToGlobals(lineType, bArrayList);
        }
    }

    private void readPccFiles(List aSelectedCampaignsList) throws PersistenceLayerException {
        if (SettingsHandler.isOptionAllowedInSources()) {
            SettingsHandler.setOptionsProperties(Globals.getCurrentPC());
        }
        for (int i = 0; i < aSelectedCampaignsList.size(); ++i) {
            Campaign aCamp = (Campaign)aSelectedCampaignsList.get(i);
            this.loadCampaignFile(aCamp);
            if (!SettingsHandler.isOptionAllowedInSources()) continue;
            LstSystemLoader.setCampaignOptions(aCamp);
        }
        this.stripLstExcludes();
        if (SettingsHandler.isOptionAllowedInSources()) {
            SettingsHandler.getOptionsFromProperties(Globals.getCurrentPC());
        }
    }

    private void stripLstExcludes() {
        this.raceFileList.removeAll(this.lstExcludeFiles);
        this.classFileList.removeAll(this.lstExcludeFiles);
        this.companionmodFileList.removeAll(this.lstExcludeFiles);
        this.skillFileList.removeAll(this.lstExcludeFiles);
        this.featFileList.removeAll(this.lstExcludeFiles);
        this.deityFileList.removeAll(this.lstExcludeFiles);
        this.domainFileList.removeAll(this.lstExcludeFiles);
        this.weaponProfFileList.removeAll(this.lstExcludeFiles);
        this.equipmentFileList.removeAll(this.lstExcludeFiles);
        this.classSkillFileList.removeAll(this.lstExcludeFiles);
        this.classSpellFileList.removeAll(this.lstExcludeFiles);
        this.spellFileList.removeAll(this.lstExcludeFiles);
        this.languageFileList.removeAll(this.lstExcludeFiles);
        this.reqSkillFileList.removeAll(this.lstExcludeFiles);
        this.templateFileList.removeAll(this.lstExcludeFiles);
        this.equipmodFileList.removeAll(this.lstExcludeFiles);
        this.coinFileList.removeAll(this.lstExcludeFiles);
        this.kitFileList.removeAll(this.lstExcludeFiles);
        this.bioSetFileList.removeAll(this.lstExcludeFiles);
    }

    private void releaseFileData() {
        this.lstExcludeFiles.clear();
        this.pccFileList.clear();
        this.raceFileList.clear();
        this.classFileList.clear();
        this.companionmodFileList.clear();
        this.skillFileList.clear();
        this.featFileList.clear();
        this.deityFileList.clear();
        this.domainFileList.clear();
        this.templateFileList.clear();
        this.weaponProfFileList.clear();
        this.equipmentFileList.clear();
        this.classSkillFileList.clear();
        this.classSpellFileList.clear();
        this.spellFileList.clear();
        this.reqSkillFileList.clear();
        this.languageFileList.clear();
        this.equipmodFileList.clear();
        this.coinFileList.clear();
        this.kitFileList.clear();
        this.bioSetFileList.clear();
    }

    private void showLicensesIfNeeded() {
        if (Globals.getUseGUI()) {
            if (this.showOGL && SettingsHandler.showLicense()) {
                pcGenGUI.showLicense();
            }
            if (this.showLicensed && SettingsHandler.showLicense()) {
                String licenseInfo = this.licensesToDisplayString.toString();
                if (licenseInfo.trim().length() > 0) {
                    pcGenGUI.showLicense("Special Licenses", licenseInfo);
                }
                pcGenGUI.showLicense("Special Licenses", this.licenseFiles);
            }
            if (this.showD20 && SettingsHandler.showD20Info()) {
                pcGenGUI.showMandatoryD20Info();
            }
        }
        Globals.getSection15().setLength(0);
        this.showOGL = false;
        this.showD20 = false;
        this.showLicensed = false;
    }

    private void sortCampaignsByRank(List aSelectedCampaignsList) {
        for (int i = 0; i < aSelectedCampaignsList.size() - 1; ++i) {
            Campaign aCamp = (Campaign)aSelectedCampaignsList.get(i);
            this.sourcesSet.add(aCamp.getSourceInForm(0));
            int aCampRank = aCamp.getRank();
            for (int j = i + 1; j < aSelectedCampaignsList.size(); ++j) {
                Campaign bCamp = (Campaign)aSelectedCampaignsList.get(j);
                if (bCamp.getRank() >= aCampRank) continue;
                aSelectedCampaignsList.set(i, bCamp);
                aSelectedCampaignsList.set(j, aCamp);
                aCamp = bCamp;
                aCampRank = aCamp.getRank();
            }
            if (aSelectedCampaignsList.size() <= 0) continue;
            aCamp = (Campaign)aSelectedCampaignsList.get(aSelectedCampaignsList.size() - 1);
            this.sourcesSet.add(aCamp.getSourceInForm(0));
        }
    }

    private void verifyWeaponsMeleeOrRanged() throws PersistenceLayerException {
        Iterator e2 = EquipmentList.getEquipmentList().iterator();
        while (e2.hasNext()) {
            Equipment aEq = (Equipment)e2.next();
            if (!aEq.isWeapon() || aEq.isMelee() || aEq.isRanged()) continue;
            throw new PersistenceLayerException("Weapon: " + aEq.getName() + " is neither Melee nor Ranged." + Constants.s_LINE_SEP + "PCGen" + " cannot calculate \"to hit\" unless one of these is selected." + Constants.s_LINE_SEP + "Source: " + aEq.getSourceFile());
        }
    }

    private void setState(Object arg) {
        this.setChanged();
        this.notifyObservers(arg);
    }

    public void update(Observable o, Object arg) {
        this.setState(arg);
    }

    public void logError(String message) {
        Logging.errorPrint(message);
        this.setChanged();
        this.notifyObservers(new Exception(message));
    }

    public void logError(String message, Throwable e) {
        Logging.errorPrint(message, e);
        this.setChanged();
        this.notifyObservers(new Exception(message + ": " + e.getMessage()));
    }
}

