/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.PCAlignment;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class PCAlignmentLoader
extends LstLineFileLoader {
    public void parseLine(String lstLine, URL sourceURL) throws PersistenceLayerException {
        PCAlignment alignment = new PCAlignment();
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (PObjectLoader.parseTag(alignment, colString)) continue;
            if (colString.startsWith("ALIGNMENTNAME:")) {
                alignment.setName(colString.substring(14));
                continue;
            }
            if (colString.startsWith("ABB:")) {
                alignment.setKeyName(colString.substring(4));
                continue;
            }
            if (colString.startsWith("VALIDFORDEITY:")) {
                alignment.setValidForDeity(colString.charAt(14) == 'Y');
                continue;
            }
            if (colString.startsWith("VALIDFORFOLLOWER:")) {
                alignment.setValidForFollower(colString.charAt(17) == 'Y');
                continue;
            }
            Logging.errorPrint("Illegal alignment info '" + lstLine + "' in " + sourceURL.toString());
        }
        if (!SettingsHandler.getGame().getUnmodifiableAlignmentList().contains(alignment)) {
            SettingsHandler.getGame().addToAlignmentList(alignment);
        }
    }
}

