/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class PCCheckLoader
extends LstLineFileLoader {
    public void parseLine(String lstLine, URL sourceURL) throws PersistenceLayerException {
        PObject obj = new PObject();
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (PObjectLoader.parseTag(obj, colString)) continue;
            if (colString.startsWith("CHECKNAME:")) {
                obj.setName(colString.substring(10));
                PCCheckLoader.addIfNew(obj);
                continue;
            }
            Logging.errorPrint("Illegal check info '" + lstLine + "' in " + sourceURL.toString());
        }
    }

    private static void addIfNew(PObject obj) {
        Iterator iter = SettingsHandler.getGame().getUnmodifiableCheckList().iterator();
        while (iter.hasNext()) {
            PObject testObj = (PObject)iter.next();
            if (!testObj.getName().equals(obj.getName())) continue;
            return;
        }
        SettingsHandler.getGame().addToCheckList(obj);
    }
}

