/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.SubClass;
import pcgen.core.utils.CoreUtility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.SubClassLoader;
import pcgen.persistence.lst.utils.FeatParser;
import pcgen.util.Logging;

public final class PCClassLoader
extends LstObjectFileLoader {
    public PObject parseLine(PObject target, String lstLine, CampaignSourceEntry source) throws PersistenceLayerException {
        PCClass pcClass = (PCClass)target;
        if (pcClass == null) {
            pcClass = new PCClass();
        }
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        int iLevel = 0;
        boolean isNumber = true;
        boolean handled = true;
        if (lstLine.startsWith("SUBCLASS:") || lstLine.startsWith("SUBCLASSLEVEL:")) {
            SubClass subClass = null;
            if (lstLine.startsWith("SUBCLASS:")) {
                String n = lstLine.substring(9, lstLine.indexOf("\t"));
                subClass = pcClass.getSubClassNamed(n);
                if (subClass == null) {
                    subClass = new SubClass();
                    subClass.setSourceCampaign(source.getCampaign());
                    subClass.setSourceFile(source.getFile());
                    pcClass.addSubClass(subClass);
                }
            } else if (pcClass.getSubClassList() != null && !pcClass.getSubClassList().isEmpty()) {
                subClass = (SubClass)pcClass.getSubClassList().get(pcClass.getSubClassList().size() - 1);
                subClass.addToLevelArray(lstLine.substring(14));
                return pcClass;
            }
            if (subClass != null) {
                SubClassLoader.parseLine(subClass, lstLine, source);
            }
            return pcClass;
        }
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (colString.startsWith("CLASS:")) {
                isNumber = false;
                String name = colString.substring(6);
                if (!name.equals(pcClass.getName()) && name.indexOf(".MOD") < 0) {
                    this.finishObject(pcClass);
                    pcClass = new PCClass();
                    pcClass.setName(name);
                    pcClass.setSourceFile(source.getFile());
                    pcClass.setSourceCampaign(source.getCampaign());
                } else if (name.endsWith(".MOD")) {
                    pcClass = Globals.getClassNamed(name.substring(0, name.length() - 4));
                }
            } else {
                if (!(pcClass instanceof SubClass) && isNumber) {
                    try {
                        iLevel = Integer.parseInt(colString);
                    }
                    catch (NumberFormatException nfe) {
                        Logging.errorPrint("Non-Numeric Level info '" + colString + "' in " + source.getFile(), nfe);
                    }
                    isNumber = false;
                    continue;
                }
                if (colString.startsWith("ABB:")) {
                    pcClass.setAbbrev(colString.substring(4));
                } else if (colString.startsWith("AC")) {
                    pcClass.getACList().add(colString.substring(3));
                } else if (colString.startsWith("ADDDOMAINS:")) {
                    pcClass.setAddDomains(iLevel, colString.substring(11), ".");
                } else if (colString.startsWith("AGESET:")) {
                    Logging.errorPrint("AGESET is a deprecated tag in " + source.getFile() + ". This functionality is now handled in biosettings.lst");
                } else if (colString.startsWith("ATTACKCYCLE:")) {
                    pcClass.setAttackCycle(colString.substring(12));
                } else if (colString.startsWith("BAB:")) {
                    pcClass.setAttackBonusType(colString.substring(4));
                } else if (colString.startsWith("BONUSSPELLSTAT:")) {
                    pcClass.setBonusSpellBaseStat(colString.substring(15));
                } else if (colString.startsWith("CAST:")) {
                    if (iLevel > 0) {
                        pcClass.setCastMap(iLevel, colString.substring(5));
                    } else {
                        Logging.errorPrint("CAST tag without level not allowed!");
                    }
                } else if (colString.startsWith("CASTAS:")) {
                    pcClass.setCastAs(colString.substring(7));
                } else {
                    if (colString.startsWith("CHECK")) continue;
                    if (colString.startsWith("DEITY:")) {
                        Object[] deities = colString.substring(6).split("\\|");
                        pcClass.setDeityList(CoreUtility.arrayToList(deities));
                    } else if (colString.startsWith("DOMAIN:")) {
                        pcClass.addDomainList(this.fixParameter(iLevel, colString.substring(7)));
                    } else if (colString.startsWith("EXCHANGELEVEL:")) {
                        pcClass.setLevelExchange(colString.substring(14));
                    } else if (colString.startsWith("EXCLASS:")) {
                        pcClass.setExClass(colString.substring(8));
                    } else if (colString.startsWith("FEAT:")) {
                        pcClass.addFeatList(iLevel, colString.substring(5));
                    } else if (colString.startsWith("FEATAUTO:")) {
                        pcClass.setFeatAutos(iLevel, colString.substring(9));
                    } else if (colString.startsWith("CRFORMULA:")) {
                        pcClass.setCRFormula(colString.substring(10));
                    } else if (colString.startsWith("XPPENALTY:")) {
                        pcClass.setXPPenalty(colString.substring(10));
                    } else if (colString.startsWith("ISMONSTER:")) {
                        pcClass.setMonsterFlag(colString.substring(10));
                    } else if (colString.equals("HASSUBCLASS")) {
                        pcClass.setHasSubClass(true);
                    } else if (colString.startsWith("GOLD:")) {
                        Logging.errorPrint("GOLD: is a deprecated tag in " + source.getFile() + ". This functionality is now handled in biosettings.lst");
                    } else if (colString.startsWith("HASSUBCLASS:")) {
                        pcClass.setHasSubClass(colString.substring(12).startsWith("Y"));
                    } else if (colString.startsWith("HD:")) {
                        try {
                            pcClass.setHitDie(Integer.parseInt(colString.substring(3)));
                        }
                        catch (Throwable t) {
                            System.err.println("Can not parse '" + colString + "' in line '" + lstLine + "'");
                        }
                    } else if (colString.startsWith("ITEMCREATE:")) {
                        pcClass.setItemCreationMultiplier(colString.substring(11));
                    } else if (colString.startsWith("KNOWN:")) {
                        pcClass.addKnown(iLevel, colString.substring(6));
                    } else if (colString.startsWith("KNOWNSPELLS:")) {
                        pcClass.addKnownSpellsList(colString.substring(12));
                    } else if (colString.startsWith("KNOWNSPELLSFROMSPECIALTY:")) {
                        pcClass.setNumSpellsFromSpecialty(Integer.parseInt(colString.substring(25)));
                    } else if (colString.startsWith("LANGBONUS")) {
                        pcClass.setLanguageBonus(colString.substring(10));
                    } else if (colString.startsWith("LEVELSPERFEAT:")) {
                        pcClass.setLevelsPerFeat(new Integer(colString.substring(14)));
                    } else if (colString.startsWith("MAXLEVEL:")) {
                        pcClass.setMaxLevel(Integer.parseInt(colString.substring(9)));
                    } else if (colString.startsWith("MEMORIZE:")) {
                        pcClass.setMemorizeSpells(colString.substring(9).startsWith("Y"));
                    } else if (colString.startsWith("MODTOSKILLS:")) {
                        pcClass.setModToSkills(!"No".equalsIgnoreCase(colString.substring(12)));
                    } else if (colString.startsWith("MONNONSKILLHD:")) {
                        pcClass.addBonusList("0|MONNONSKILLHD|NUMBER|" + colString.substring(14).trim(), pcClass);
                    } else if (colString.startsWith("MONSKILL:")) {
                        pcClass.addBonusList("0|MONSKILLPTS|NUMBER|" + colString.substring(9).trim() + "|PRELEVELMAX:1", pcClass);
                    } else if (colString.startsWith("MULTIPREREQS")) {
                        pcClass.setMultiPreReqs(true);
                    } else if (colString.startsWith("PRERACETYPE:")) {
                        pcClass.setPreRaceType(colString.substring(12));
                    } else if (colString.startsWith("PROHIBITED:")) {
                        pcClass.setProhibitedString(colString.substring(11));
                    } else if (colString.startsWith("QUALIFY:")) {
                        pcClass.setQualifyString(colString.substring(8));
                    } else if (colString.startsWith("SKILLLIST:")) {
                        pcClass.setClassSkillString(colString.substring(10));
                    } else if (colString.startsWith("SPECIALS:")) {
                        Logging.errorPrint("SPECIALS in class files is now deprecated, please use feats instead.");
                        pcClass.setSpecialsString(colString.substring(9));
                    } else if (colString.startsWith("SPECIALTYKNOWN:")) {
                        pcClass.getSpecialtyKnownList().add(colString.substring(15));
                    } else if (colString.startsWith("SPELLBOOK:")) {
                        pcClass.setSpellBookUsed(colString.charAt(10) == 'Y');
                    } else if (colString.startsWith("SPELLLIST:")) {
                        pcClass.setSpellLevelString(colString.substring(10));
                    } else if (colString.startsWith("SPELLSTAT:")) {
                        pcClass.setSpellBaseStat(colString.substring(10));
                    } else if (colString.startsWith("SPELLTYPE:")) {
                        pcClass.setSpellType(colString.substring(10));
                    } else if (colString.startsWith("STARTSKILLPTS:")) {
                        pcClass.setSkillPoints(Integer.parseInt(colString.substring(14)));
                    } else if (colString.startsWith("SUBCLASS:")) {
                        pcClass.setSubClassString(this.fixParameter(iLevel, colString.substring(9)));
                    } else if (colString.startsWith("SUBSA:")) {
                        Logging.errorPrint("SUBSA is a deprecated tag in " + source.getFile() + ". This functionality is now handled in biosettings.lst");
                    } else if (colString.startsWith("TEMPLATE:")) {
                        pcClass.addTemplate(this.fixParameter(iLevel, colString.substring(9)));
                    } else if (colString.startsWith("UATT:")) {
                        pcClass.getUattList().add(colString.substring(5));
                    } else if (colString.startsWith("VFEAT:")) {
                        List vFeatList = FeatParser.parseVirtualFeatList(colString.substring(6));
                        pcClass.addVirtualFeats(iLevel, vFeatList);
                    } else if (colString.startsWith("VISIBLE:")) {
                        pcClass.setVisible(colString.substring(8).toUpperCase().startsWith("Y"));
                    } else if (colString.startsWith("WEAPONBONUS")) {
                        pcClass.setWeaponProfBonus(colString.substring(12));
                    } else if (colString.startsWith("XTRAFEATS:")) {
                        pcClass.setInitialFeats(Integer.parseInt(colString.substring(10)));
                    } else {
                        if (PObjectLoader.parseTagLevel(pcClass, colString, iLevel)) continue;
                        if (!(pcClass instanceof SubClass)) {
                            Logging.errorPrint("Illegal class info tag '" + colString + "' in " + source.getFile());
                        }
                    }
                }
            }
            isNumber = false;
        }
        return pcClass;
    }

    protected PObject getObjectNamed(String baseName) {
        if (baseName.startsWith("CLASS:")) {
            baseName = baseName.substring(6);
        }
        return Globals.getClassNamed(baseName);
    }

    protected void finishObject(PObject target) {
        if (this.includeObject(target)) {
            PCClass bClass = Globals.getClassNamed(target.getName());
            if (bClass == null) {
                Globals.getClassList().add(target);
            } else if (!bClass.getSourceFile().equals(target.getSourceFile())) {
                Logging.errorPrint("WARNING: Duplicate class name: " + target.getName());
                Logging.errorPrint("Original : " + bClass.getSourceFile());
                Logging.errorPrint("Duplicate: " + target.getSourceFile());
                Logging.errorPrint("WARNING: Not loading duplicate");
            }
        }
    }

    protected void performForget(PObject objToForget) {
        Globals.getClassList().remove(objToForget);
    }

    private String fixParameter(int aInt, String colString) {
        return aInt + "|" + colString;
    }
}

