/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.PCStat;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class PCStatLoader
extends LstLineFileLoader {
    public void parseLine(String lstLine, URL sourceURL) throws PersistenceLayerException {
        PCStat stat = new PCStat();
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (colString.startsWith("ABB:")) {
                stat.setAbb(colString.substring(4));
                continue;
            }
            if (colString.startsWith("STATMOD:")) {
                stat.setStatMod(colString.substring(8));
                continue;
            }
            if (colString.startsWith("STATNAME:")) {
                stat.setName(colString.substring(9));
                continue;
            }
            if (colString.startsWith("STATRANGE:")) {
                stat.setStatRange(colString.substring(10));
                continue;
            }
            if (PObjectLoader.parseTag(stat, colString)) continue;
            if (colString.startsWith("PENALTYVAR:")) {
                stat.setPenaltyVar(colString.substring(11));
                continue;
            }
            Logging.errorPrint("Illegal stat info '" + lstLine + "' in " + sourceURL.toString());
        }
        SettingsHandler.getGame().addToStatList(stat);
    }
}

