/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.PCTemplate;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class PCTemplateLoader {
    private PCTemplateLoader() {
    }

    public static void parseLine(PCTemplate template, String inputLine, URL sourceURL, int lineNum) throws PersistenceLayerException {
        if (template == null) {
            return;
        }
        StringTokenizer colToken = new StringTokenizer(inputLine, "\t");
        String templName = "None";
        int col = 0;
        if (!template.isNewItem()) {
            col = 1;
            colToken.nextToken();
        }
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (colString.startsWith("REGION:")) {
                String region = colString.substring(7);
                if ("Yes".equalsIgnoreCase(region)) {
                    region = templName;
                }
                template.setRegion(region);
                continue;
            }
            if (PObjectLoader.parseTag(template, colString)) continue;
            if (col == 0) {
                template.setName(colString);
                templName = template.getName();
            } else if (colString.startsWith("AGE:")) {
                template.setAgeString(colString.substring(4));
            } else if (colString.startsWith("BONUSFEATS:")) {
                template.setBonusInitialFeats(Integer.parseInt(colString.substring(11)));
            } else if (colString.startsWith("BONUSSKILLPOINTS:")) {
                template.setBonusSkillsPerLevel(Integer.parseInt(colString.substring(17)));
            } else if (colString.startsWith("CHOOSE:LANGAUTO:")) {
                template.setChooseLanguageAutos(colString.substring(16));
            } else if (colString.startsWith("COST:")) {
                template.setCost(colString.substring(5));
            } else if (colString.startsWith("CR:")) {
                template.setCR(Integer.parseInt(colString.substring(3)));
            } else if (colString.startsWith("FAVOREDCLASS:")) {
                template.setFavoredClass(colString.substring(13));
            } else if (colString.startsWith("FEAT:")) {
                template.addFeatString(colString.substring(5));
            } else if (colString.startsWith("GENDERLOCK:")) {
                template.setGenderLock(colString.substring(11));
            } else if (colString.startsWith("GOLD:")) {
                Logging.errorPrint("GOLD: tag in " + sourceURL.toString() + " no longer supported due to OGL compliance");
            } else if (colString.startsWith("HANDEDLOCK:")) {
                template.setHandedLock(colString.substring(11));
            } else if (colString.startsWith("HD:")) {
                template.addHitDiceString(colString.substring(3));
            } else if (colString.startsWith("HEIGHT:")) {
                template.setHeightString(colString.substring(7));
            } else if (colString.startsWith("HITDIE:")) {
                template.setHitDieLock(colString.substring(7));
            } else if (colString.startsWith("HITDICESIZE:")) {
                Logging.errorPrint("HITDICESIZE deprecated, use HITDIE in file " + sourceURL.getFile());
            } else if (colString.startsWith("LANGBONUS")) {
                template.setLanguageBonus(colString.substring(10));
            } else if (colString.startsWith("LEVEL:")) {
                template.addLevelString(colString.substring(6));
            } else if (colString.startsWith("LEVELADJUSTMENT:")) {
                template.setLevelAdjustment(colString.substring(16));
            } else if (colString.startsWith("LEVELSPERFEAT:")) {
                int newLevels = Integer.parseInt(colString.substring(14));
                if (newLevels >= 0) {
                    template.setLevelsPerFeat(newLevels);
                }
            } else if (colString.startsWith("NONPP:")) {
                template.setNonProficiencyPenalty(Integer.parseInt(colString.substring(6)));
            } else if (!colString.startsWith("POPUPALERT:")) {
                if (colString.startsWith("SIZE:")) {
                    template.setTemplateSize(colString.substring(5));
                } else if (colString.startsWith("WEIGHT:")) {
                    template.setWeightString(colString.substring(7));
                } else if (colString.startsWith("QUALIFY:")) {
                    template.setQualifyString(colString.substring(8));
                } else if (colString.startsWith("REMOVABLE:")) {
                    if (colString.substring(10).startsWith("No")) {
                        template.setRemovable(false);
                    }
                } else if (colString.startsWith("SUBRACE:")) {
                    String subRace = colString.substring(8);
                    if ("Yes".equalsIgnoreCase(subRace)) {
                        subRace = templName;
                    }
                    template.setSubRace(subRace);
                } else if (colString.startsWith("SUBREGION:")) {
                    String subregion = colString.substring(10);
                    if ("Yes".equalsIgnoreCase(subregion)) {
                        subregion = templName;
                    }
                    template.setSubRegion(subregion);
                } else if (colString.startsWith("TEMPLATE:")) {
                    template.addTemplate(colString.substring(9));
                } else if (colString.startsWith("VISIBLE:")) {
                    String visType = colString.substring(8).toUpperCase();
                    if (visType.startsWith("DISPLAY")) {
                        template.setVisible(3);
                    } else if (visType.startsWith("EXPORT")) {
                        template.setVisible(2);
                    } else if (visType.startsWith("NO")) {
                        template.setVisible(0);
                    } else {
                        template.setVisible(1);
                    }
                } else if (colString.startsWith("WEAPONBONUS")) {
                    template.setWeaponProfBonus(colString.substring(12));
                }
            }
            ++col;
        }
    }
}

