/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Campaign;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCSpell;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.core.SpecialAbility;
import pcgen.core.WeaponProf;
import pcgen.core.prereq.Prerequisite;
import pcgen.io.EntityEncoder;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.persistence.lst.utils.FeatParser;
import pcgen.persistence.lst.utils.PObjectHelper;
import pcgen.util.Logging;

public final class PObjectLoader {
    private static List featList = new ArrayList();

    private PObjectLoader() {
    }

    public static Map parseSource(String sourceLine) {
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        StringTokenizer aTok = new StringTokenizer(sourceLine, "|");
        while (aTok.hasMoreTokens()) {
            String arg = aTok.nextToken();
            String key = arg.substring(6, arg.indexOf(":"));
            String val = arg.substring(arg.indexOf(":") + 1);
            sourceMap.put(key, val);
        }
        return sourceMap;
    }

    public static boolean parseTag(PObject obj, String aTag) throws PersistenceLayerException {
        return PObjectLoader.parseTagLevel(obj, aTag, -9);
    }

    public static boolean parseTagLevel(PObject obj, String aTag, int anInt) throws PersistenceLayerException {
        if (obj == null || aTag.length() < 1) {
            return false;
        }
        obj.setNewItem(false);
        char firstLetter = aTag.charAt(0);
        boolean result = false;
        switch (firstLetter) {
            case 'A': {
                result = PObjectLoader.parseATagLevel(obj, aTag, anInt);
                break;
            }
            case 'B': {
                result = PObjectLoader.parseBTagLevel(obj, aTag, anInt);
                break;
            }
            case 'C': {
                result = PObjectLoader.parseCTagLevel(obj, aTag, anInt);
                break;
            }
            case 'D': {
                result = PObjectLoader.parseDTagLevel(obj, aTag, anInt);
                break;
            }
            case 'H': {
                result = PObjectLoader.parseHTagLevel(obj, aTag, anInt);
                break;
            }
            case 'K': {
                result = PObjectLoader.parseKTagLevel(obj, aTag, anInt);
                break;
            }
            case 'L': {
                result = PObjectLoader.parseLTagLevel(obj, aTag, anInt);
                break;
            }
            case 'M': {
                result = PObjectLoader.parseMTagLevel(obj, aTag, anInt);
                break;
            }
            case 'N': {
                result = PObjectLoader.parseNTagLevel(obj, aTag, anInt);
                break;
            }
            case 'O': {
                result = PObjectLoader.parseOTagLevel(obj, aTag, anInt);
                break;
            }
            case '!': 
            case 'P': 
            case 'R': {
                result = PObjectLoader.parsePTagLevel(obj, aTag, anInt);
                break;
            }
            case 'S': {
                result = PObjectLoader.parseSTagLevel(obj, aTag, anInt);
                break;
            }
            case 'T': {
                result = PObjectLoader.parseTTagLevel(obj, aTag, anInt);
                break;
            }
            case 'U': {
                result = PObjectLoader.parseUTagLevel(obj, aTag, anInt);
                break;
            }
            case 'V': {
                result = PObjectLoader.parseVTagLevel(obj, aTag, anInt);
                break;
            }
            case 'W': {
                result = PObjectLoader.parseWTagLevel(obj, aTag, anInt);
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private static List createSpellsList(String sourceLine) {
        ArrayList spellList = new ArrayList();
        StringTokenizer tok = new StringTokenizer(sourceLine, "|");
        if (tok.countTokens() > 1) {
            StringTokenizer bookTok = new StringTokenizer(tok.nextToken(), ",");
            String spellBook = bookTok.nextToken();
            String casterLevel = null;
            String times = "1";
            while (bookTok.hasMoreTokens()) {
                String param = bookTok.nextToken();
                if (param.startsWith("CASTERLEVEL=")) {
                    casterLevel = param.substring(12);
                    continue;
                }
                if (!param.startsWith("TIMES=")) continue;
                times = param.substring(6);
            }
            ArrayList<String> preParseSpellList = new ArrayList<String>();
            ArrayList<Prerequisite> preList = new ArrayList<Prerequisite>();
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (token.startsWith("PRE") || token.startsWith("!PRE")) {
                    try {
                        PreParserFactory factory = PreParserFactory.getInstance();
                        preList.add(factory.parse(token));
                    }
                    catch (PersistenceLayerException ple) {
                        Logging.errorPrint(ple.getMessage(), ple);
                    }
                    continue;
                }
                preParseSpellList.add(token);
            }
            for (int i = 0; i < preParseSpellList.size(); ++i) {
                StringTokenizer spellTok = new StringTokenizer((String)preParseSpellList.get(i), ",");
                String name = spellTok.nextToken();
                String dcFormula = null;
                if (spellTok.hasMoreTokens()) {
                    dcFormula = spellTok.nextToken();
                }
                PCSpell spell = new PCSpell();
                spell.setName(name);
                spell.setKeyName(spell.getName());
                spell.setSpellbook(spellBook);
                spell.setCasterLevelFormula(casterLevel);
                spell.setTimesFormula(times);
                spell.setDcFormula(dcFormula);
            }
        } else {
            Logging.errorPrint("SPELLS: line minimally requires SPELLS:<spellbook name>|<spell name>");
        }
        return spellList;
    }

    private static List createSpellList(int level, String sourceLine) {
        return PObjectLoader.createSpellList(sourceLine);
    }

    private static List createSpellList(String sourceLine) {
        int i;
        ArrayList<PCSpell> spellList = new ArrayList<PCSpell>();
        String preTag = "";
        String spellSrc = "";
        StringBuffer spellSrcBuffer = new StringBuffer();
        StringBuffer preTagBuffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(sourceLine, "|");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("PRE") || token.startsWith("!PRE")) {
                preTagBuffer.append(token);
                preTagBuffer.append("|");
                continue;
            }
            spellSrcBuffer.append(token);
            spellSrcBuffer.append("|");
        }
        if (preTagBuffer.length() > 0 && preTagBuffer.toString().endsWith("|")) {
            preTag = preTagBuffer.substring(0, preTagBuffer.length() - 1);
        }
        if (spellSrcBuffer.length() > 0 && spellSrcBuffer.toString().endsWith("|")) {
            spellSrc = spellSrcBuffer.substring(0, spellSrcBuffer.length() - 1);
        }
        if ((i = sourceLine.lastIndexOf(91)) >= 0) {
            int j = sourceLine.lastIndexOf(93);
            if (sourceLine.charAt(j - 1) == ']') {
                Logging.errorPrint("The SPELL: tag with [PRExxx] syntax with mulitiple [] characters is no longer supported.");
                Logging.errorPrint("Please change: " + sourceLine);
            }
            if (j < i) {
                j = sourceLine.length();
            }
            preTag = sourceLine.substring(i + 1, j);
            spellSrc = sourceLine.substring(0, i);
            Logging.errorPrint("The SPELL: tag with [PRExxx] syntax has been deprecated.");
            Logging.errorPrint("Please change: " + sourceLine);
        }
        StringTokenizer aTok = new StringTokenizer(spellSrc, "|");
        while (aTok.hasMoreTokens()) {
            PCSpell spell = new PCSpell();
            spell.setName(aTok.nextToken());
            spell.setKeyName(spell.getName());
            if (aTok.hasMoreTokens()) {
                spell.setTimesPerDay(aTok.nextToken());
            } else {
                spell.setTimesPerDay("1");
            }
            if (aTok.hasMoreTokens()) {
                spell.setSpellbook(aTok.nextToken());
            } else {
                spell.setSpellbook("Innate");
            }
            if (preTag != null) {
                StringTokenizer preTok = new StringTokenizer(preTag, "|");
                while (preTok.hasMoreTokens()) {
                    try {
                        PreParserFactory factory = PreParserFactory.getInstance();
                        spell.addPreReq(factory.parse(preTok.nextToken()));
                    }
                    catch (PersistenceLayerException ple) {
                        Logging.errorPrint(ple.getMessage(), ple);
                    }
                }
            }
            spellList.add(spell);
        }
        return spellList;
    }

    private static boolean parseATagLevel(PObject obj, String aTag, int anInt) {
        if (aTag.startsWith("ADD:")) {
            obj.addAddList(anInt, aTag.substring(4));
        } else if (aTag.startsWith("AUTO:")) {
            obj.addAutoArray(aTag.substring(5));
        } else {
            return false;
        }
        return true;
    }

    private static boolean parseBTagLevel(PObject obj, String aTag, int anInt) {
        boolean result = false;
        if (aTag.startsWith("BONUS:")) {
            result = anInt > -9 ? obj.addBonusList(anInt + "|" + aTag.substring(6), obj) : obj.addBonusList(aTag.substring(6), obj);
        }
        return result;
    }

    private static boolean parseCTagLevel(PObject obj, String aTag, int anInt) {
        if (!aTag.startsWith("CAMPAIGN:") || obj instanceof Campaign) {
            if (aTag.startsWith("CHANGEPROF:")) {
                obj.addChangeProf(aTag.substring(11));
            } else if (aTag.startsWith("CHOOSE:") && !aTag.startsWith("CHOOSE:LANGAUTO")) {
                obj.setChoiceString(aTag.substring(7));
            } else if (aTag.startsWith("CSKILL:")) {
                obj.setCSkillList(aTag.substring(7));
            } else if (aTag.startsWith("CCSKILL:")) {
                obj.setCcSkillList(aTag.substring(8));
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean parseDTagLevel(PObject obj, String aTag, int anInt) throws PersistenceLayerException {
        if (aTag.startsWith("DEFINE:")) {
            String[] tokens = aTag.substring(7).split("\\|");
            if (tokens.length != 2) {
                throw new PersistenceLayerException("Unable to parse the Define '" + aTag + "'. All defines are of the form DEFINE:variable|defaultValue.");
            }
            obj.addVariable(anInt, tokens[0], tokens[1]);
        } else if (aTag.startsWith("DESC:")) {
            obj.setDescription(EntityEncoder.decode(aTag.substring(5)));
        } else if (aTag.startsWith("DESCISPI:")) {
            obj.setDescIsPI(aTag.substring(9).startsWith("Y"));
        } else if (aTag.startsWith("DR:")) {
            if (anInt > -9) {
                obj.setDR(anInt + "|" + aTag.substring(3));
            } else {
                obj.setDR(aTag.substring(3));
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean parseHTagLevel(PObject obj, String aTag, int anInt) throws PersistenceLayerException {
        if (aTag.startsWith("HITDIE:")) {
            if (!(obj instanceof PCClass)) {
                return false;
            }
        } else {
            return false;
        }
        ((PCClass)obj).putHitDieLock(aTag.substring(7), anInt);
        return true;
    }

    private static boolean parseKTagLevel(PObject obj, String aTag, int anInt) {
        if (aTag.startsWith("KEY:")) {
            obj.setKeyName(aTag.substring(4));
        } else if (aTag.startsWith("KIT:")) {
            if (anInt > -9) {
                obj.setKitString(anInt + "|" + aTag.substring(4));
            } else {
                obj.setKitString("0|" + aTag.substring(4));
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean parseLTagLevel(PObject obj, String aTag, int anInt) {
        if (!aTag.startsWith("LANGAUTO:")) {
            return false;
        }
        obj.addLanguageAutos(aTag.substring(9));
        return true;
    }

    private static boolean parseMTagLevel(PObject obj, String aTag, int anInt) {
        if (aTag.startsWith("MOVE:")) {
            if (obj instanceof Equipment) {
                return false;
            }
            obj.setMoveRates(aTag.substring(5));
            obj.setMoveRatesFlag(0);
        } else if (aTag.startsWith("MOVEA:")) {
            obj.setMoveRates(aTag.substring(6));
            obj.setMoveRatesFlag(1);
        } else if (aTag.startsWith("MOVECLONE:")) {
            obj.setMoveRates(aTag.substring(10));
            obj.setMoveRatesFlag(2);
        } else {
            return false;
        }
        return true;
    }

    private static boolean parseNTagLevel(PObject obj, String aTag, int anInt) {
        if (aTag.startsWith("NAME:")) {
            obj.setName(aTag.substring(5));
        } else if (aTag.startsWith("NAMEISPI:")) {
            obj.setNameIsPI(aTag.substring(9).startsWith("Y"));
        } else if (aTag.startsWith("NATURALATTACKS:")) {
            List naturalWeapons = PObjectLoader.parseNaturalAttacks(obj, aTag.substring(15));
            Iterator iter = naturalWeapons.iterator();
            while (iter.hasNext()) {
                Equipment element = (Equipment)iter.next();
                obj.addNaturalWeapon(element, anInt);
            }
        } else {
            return false;
        }
        return true;
    }

    private static List parseNaturalAttacks(PObject obj, String aString) {
        String aSize = "M";
        if (obj instanceof PCTemplate) {
            aSize = ((PCTemplate)obj).getTemplateSize();
        } else if (obj instanceof Race) {
            aSize = ((Race)obj).getSize();
        }
        if (aSize == null) {
            aSize = "M";
        }
        boolean firstWeapon = true;
        boolean onlyOne = false;
        StringTokenizer attackTok = new StringTokenizer(aString, "|");
        if (attackTok.countTokens() == 1) {
            onlyOne = true;
        }
        ArrayList<Equipment> naturalWeapons = new ArrayList<Equipment>();
        while (attackTok.hasMoreTokens()) {
            StringTokenizer aTok = new StringTokenizer(attackTok.nextToken(), ",");
            Equipment anEquip = PObjectLoader.createNaturalWeapon(aTok, aSize);
            if (anEquip != null) {
                if (firstWeapon) {
                    anEquip.setModifiedName("Natural/Primary");
                } else {
                    anEquip.setModifiedName("Natural/Secondary");
                }
                if (onlyOne && anEquip.isOnlyNaturalWeapon()) {
                    anEquip.setOnlyNaturalWeapon(true);
                } else {
                    anEquip.setOnlyNaturalWeapon(false);
                }
                naturalWeapons.add(anEquip);
            }
            firstWeapon = false;
        }
        return naturalWeapons;
    }

    private static Equipment createNaturalWeapon(StringTokenizer aTok, String aSize) {
        String attackName = aTok.nextToken();
        if (attackName.equalsIgnoreCase("None")) {
            return null;
        }
        Equipment anEquip = new Equipment();
        String profType = aTok.nextToken();
        anEquip.setName(attackName);
        anEquip.setTypeInfo(profType);
        anEquip.setWeight("0");
        anEquip.setSize(aSize, true);
        String numAttacks = aTok.nextToken();
        boolean attacksProgress = true;
        if (numAttacks.length() > 0 && numAttacks.charAt(0) == '*') {
            numAttacks = numAttacks.substring(1);
            attacksProgress = false;
        }
        int bonusAttacks = 0;
        try {
            bonusAttacks = Integer.parseInt(numAttacks) - 1;
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("Non-numeric value for number of attacks: '" + numAttacks + "'");
        }
        if (bonusAttacks > 0) {
            anEquip.addBonusList("WEAPON|ATTACKS|" + bonusAttacks);
            anEquip.setOnlyNaturalWeapon(false);
        } else {
            anEquip.setOnlyNaturalWeapon(true);
        }
        anEquip.setDamage(aTok.nextToken());
        anEquip.setCritRange("1");
        anEquip.setCritMult("x2");
        anEquip.setProfName(attackName);
        int handsRequired = 0;
        if (aTok.hasMoreTokens()) {
            String hString = aTok.nextToken();
            try {
                handsRequired = Integer.parseInt(hString);
            }
            catch (NumberFormatException exc) {
                Logging.errorPrint("Non-numeric value for hands required: '" + hString + "'");
            }
        }
        anEquip.setSlots(handsRequired);
        anEquip.setQty(new Float(1.0f));
        anEquip.setNumberCarried(new Float(1.0f));
        anEquip.setAttacksProgress(attacksProgress);
        WeaponProf prof = Globals.getWeaponProfKeyed(attackName);
        if (prof == null) {
            prof = new WeaponProf();
            prof.setTypeInfo(profType);
            prof.setName(attackName);
            prof.setKeyName(attackName);
            Globals.addWeaponProf(prof);
        }
        return anEquip;
    }

    private static boolean parseOTagLevel(PObject obj, String aTag, int anInt) {
        if (!aTag.startsWith("OUTPUTNAME:")) {
            return false;
        }
        obj.setOutputName(aTag.substring(11));
        return true;
    }

    private static boolean parsePTagLevel(PObject obj, String aTag, int anInt) throws PersistenceLayerException {
        if (aTag.startsWith("PRE") || aTag.startsWith("!PRE") || aTag.startsWith("RESTRICT:")) {
            if (aTag.toUpperCase().equals("PRE:.CLEAR")) {
                obj.clearPreReq();
            } else {
                try {
                    PreParserFactory factory = PreParserFactory.getInstance();
                    obj.addPreReq(factory.parse(aTag), anInt);
                }
                catch (PersistenceLayerException ple) {
                    throw new PersistenceLayerException("Unable to parse a prerequisite: " + ple.getMessage());
                }
            }
        } else if (aTag.startsWith("REGION:")) {
            if (anInt > -9) {
                obj.setRegionString(anInt + "|" + aTag.substring(7));
            } else {
                obj.setRegionString("0|" + aTag.substring(7));
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean parseSTagLevel(PObject obj, String aTag, int anInt) {
        if (aTag.startsWith("SOURCE")) {
            obj.setSourceMap(PObjectLoader.parseSource(aTag));
        } else if (aTag.startsWith("SA:")) {
            PObjectLoader.parseSpecialAbility(obj, aTag.substring(3), anInt);
        } else if (aTag.startsWith("SPELLS:") && !(obj instanceof Campaign)) {
            obj.addSpells(anInt, PObjectLoader.createSpellsList(aTag.substring(7)));
        } else if (aTag.startsWith("SPELL:") && !(obj instanceof Campaign)) {
            obj.addSpells(anInt, PObjectLoader.createSpellList(aTag.substring(6)));
        } else if (aTag.startsWith("SPELLLEVEL:") && !(obj instanceof Campaign)) {
            obj.addSpellLevel(aTag.substring(11));
        } else if (aTag.startsWith("SR:")) {
            if (anInt > -9) {
                obj.setSR(anInt + "|" + aTag.substring(3));
            } else {
                obj.setSR(aTag.substring(3));
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean parseTTagLevel(PObject obj, String aTag, int anInt) {
        if (aTag.startsWith("TYPE:")) {
            obj.setTypeInfo(aTag.substring("TYPE:".length()));
        } else if (aTag.startsWith("TEMPDESC:")) {
            obj.setTempDescription(EntityEncoder.decode(aTag.substring(9)));
        } else if (aTag.startsWith("TEMPLATE:") && !(obj instanceof Campaign)) {
            obj.addTemplate(aTag.substring(9));
        } else {
            return false;
        }
        return true;
    }

    private static boolean parseUTagLevel(PObject obj, String aTag, int anInt) {
        if (aTag.startsWith("UDAM:")) {
            obj.addUdamList(aTag.substring(5));
        } else if (aTag.startsWith("UMULT:")) {
            if (anInt > -9) {
                obj.addUmult(anInt + "|" + aTag.substring(6));
            } else {
                obj.addUmult(aTag.substring(6));
            }
        } else if (aTag.startsWith("UNENCUMBEREDMOVE:")) {
            obj.setUnencumberedMove(aTag.substring(17));
        } else {
            return false;
        }
        return true;
    }

    private static boolean parseVTagLevel(PObject obj, String aTag, int anInt) {
        if (aTag.startsWith("VFEAT:")) {
            featList.add(new PObjectHelper(obj, aTag.substring(6), anInt));
        } else if (aTag.startsWith("VISION:")) {
            if (anInt > -9) {
                obj.setVision(anInt + "|" + aTag.substring(7), null);
            } else {
                obj.setVision(aTag.substring(7), null);
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean parseWTagLevel(PObject obj, String aTag, int anInt) {
        if (!aTag.startsWith("WEAPONAUTO:")) {
            return false;
        }
        obj.addWeaponProfAutos(aTag.substring(11));
        return true;
    }

    public static void parseSpecialAbility(PObject obj, String aString, int level) {
        StringTokenizer aTok = new StringTokenizer(aString, "|", true);
        if (!aTok.hasMoreTokens()) {
            return;
        }
        String saName = aTok.nextToken();
        boolean inPreReq = false;
        SpecialAbility sa = new SpecialAbility();
        while (aTok.hasMoreTokens()) {
            String cString = aTok.nextToken();
            if (cString.startsWith("PRE") && cString.indexOf(":") > 0) {
                try {
                    PreParserFactory factory = PreParserFactory.getInstance();
                    Prerequisite prereq = factory.parse(cString);
                    sa.addPreReq(prereq);
                }
                catch (PersistenceLayerException ple) {
                    Logging.errorPrint(ple.getMessage(), ple);
                }
            } else {
                saName = saName + cString;
            }
            if (!".CLEAR".equals(cString)) continue;
            obj.clearSpecialAbilityList();
            saName = "";
        }
        sa.setName(saName);
        if (obj instanceof PCClass) {
            sa.setSASource("PCCLASS=" + obj.getName() + "|" + level);
        }
        if (!aString.equals(".CLEAR")) {
            Globals.addToSASet(sa);
            obj.addSpecialAbilityToList(sa);
        }
    }

    public static void finishFeatProcessing() {
        Iterator i = featList.iterator();
        while (i.hasNext()) {
            PObjectHelper p = (PObjectHelper)i.next();
            List vFeatList = FeatParser.parseVirtualFeatList(p.getTag());
            p.getObject().addVirtualFeats(vFeatList);
        }
    }
}

