/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PaperInfo;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.util.Logging;

final class PaperInfoLoader
extends LstLineFileLoader {
    public void loadLstFile(String fileName) throws PersistenceLayerException {
        SystemCollections.clearPaperInfoList();
        super.loadLstFile(fileName);
        Globals.selectPaper(SettingsHandler.getPCGenOption("paperName", "A4"));
    }

    public void parseLine(String lstLine, URL sourceURL) throws PersistenceLayerException {
        PaperInfo psize = new PaperInfo();
        StringTokenizer aTok = new StringTokenizer(lstLine, "\t");
        int iCount = 0;
        while (aTok.hasMoreElements()) {
            String colString = (String)aTok.nextElement();
            try {
                psize.setPaperInfo(iCount, colString);
            }
            catch (IndexOutOfBoundsException e) {
                Logging.errorPrint("Illegal paper size info '" + lstLine + "' in " + sourceURL.toString());
            }
            ++iCount;
        }
        SystemCollections.addToPaperInfoList(psize);
    }
}

