/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.Constants;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.util.Logging;

public class PointBuyLoader
extends LstLineFileLoader {
    public void parseLine(String lstLine, URL sourceURL) throws PersistenceLayerException {
        boolean bError;
        block7: {
            StringTokenizer pbTok = new StringTokenizer(lstLine, "\t");
            bError = false;
            if (pbTok.countTokens() == 2) {
                String token1 = pbTok.nextToken();
                String token2 = pbTok.nextToken();
                try {
                    if (token1.startsWith("STAT:") && token2.startsWith("COST:")) {
                        int statValue = Integer.parseInt(token1.substring(5));
                        int cost = Integer.parseInt(token2.substring(5));
                        SettingsHandler.addPointBuyStatCost(statValue, cost);
                        break block7;
                    }
                    if (token1.startsWith("METHOD:") && token2.startsWith("POINTS:")) {
                        String methodName = token1.substring(7);
                        int points = Integer.parseInt(token2.substring(7));
                        SettingsHandler.addPurchaseModeMethod(methodName, points);
                        break block7;
                    }
                    bError = true;
                }
                catch (NumberFormatException exc) {
                    Logging.errorPrint("NumberFormatException in Point Buy Line:" + Constants.s_LINE_SEP, exc);
                    bError = true;
                }
            } else {
                bError = true;
            }
        }
        if (bError) {
            Logging.errorPrint("Illegal point buy info '" + lstLine + "' in " + sourceURL.toString());
        }
    }
}

