/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class RaceLoader
extends LstObjectFileLoader {
    public PObject parseLine(PObject target, String lstLine, CampaignSourceEntry source) throws PersistenceLayerException {
        Race race = (Race)target;
        if (race == null) {
            race = new Race();
        }
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        int col = -1;
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (++col < 10 && colString.indexOf(58) >= 0) {
                col = 10;
            }
            if (col == 0) {
                race.setName(colString);
                race.setSourceCampaign(source.getCampaign());
                race.setSourceFile(source.getFile());
                continue;
            }
            if (colString.startsWith("AC:")) {
                race.setStartingAC(new Integer(colString.substring(3)));
                continue;
            }
            if (colString.length() > 5 && colString.startsWith("AGE:")) {
                Logging.errorPrint("AGESET is a deprecated tag in " + source.getFile() + ". This functionality is now handled in biosettings.lst");
                continue;
            }
            if (colString.startsWith("AL:")) {
                Prerequisite prereq = new Prerequisite();
                for (int i = 3; i < colString.length(); ++i) {
                    Prerequisite subreq = new Prerequisite();
                    subreq.setKind("align");
                    subreq.setKey(colString.substring(i, i + 1));
                    prereq.addPrerequisite(subreq);
                }
                race.addPreReq(prereq);
                continue;
            }
            if (colString.startsWith("BAB:")) {
                race.setBAB(Integer.parseInt(colString.substring(4)));
                continue;
            }
            if (colString.startsWith("CHOOSE:LANGAUTO:")) {
                race.setChooseLanguageAutos(colString.substring(16));
                continue;
            }
            if (colString.startsWith("CR:")) {
                String cr = colString.substring(3);
                if (cr.startsWith("1/")) {
                    cr = "-" + cr.substring(2);
                }
                race.setCR(Integer.parseInt(cr));
                continue;
            }
            if (colString.startsWith("FACE:")) {
                int width;
                String face = colString.substring(5);
                if (face.indexOf(",") > -1) {
                    width = 5;
                    int height = 5;
                    try {
                        width = Integer.parseInt(face.substring(0, face.indexOf(",") - 1).trim());
                    }
                    catch (NumberFormatException ne) {
                        // empty catch block
                    }
                    try {
                        height = Integer.parseInt(face.substring(face.indexOf(",") + 1).trim());
                    }
                    catch (NumberFormatException ne) {
                        // empty catch block
                    }
                    race.setFace(width, height);
                    continue;
                }
                width = 5;
                try {
                    width = Integer.parseInt(face.trim());
                }
                catch (NumberFormatException ne) {
                    // empty catch block
                }
                race.setFace(width, 0);
                continue;
            }
            if (colString.startsWith("FAVCLASS:")) {
                race.setFavoredClass(colString.substring(9));
                continue;
            }
            if (colString.startsWith("FEAT")) {
                race.setFeatList(colString.substring(5));
                continue;
            }
            if (colString.startsWith("HANDS:")) {
                race.setHands(Integer.parseInt(colString.substring(6)));
                continue;
            }
            if (colString.length() > 5 && colString.startsWith("HEIGHT:")) {
                Logging.errorPrint("HEIGHT is a deprecated tag in " + source.getFile() + ". This functionality is now handled in biosettings.lst");
                continue;
            }
            if (colString.startsWith("HITDICE:")) {
                StringTokenizer hitdice = new StringTokenizer(colString.substring(8), ",");
                if (hitdice.countTokens() != 2) {
                    Logging.errorPrint("Illegal racial hit dice format '" + colString + "' in " + source.getFile());
                    continue;
                }
                race.setHitDice(Integer.parseInt(hitdice.nextToken()));
                race.setHitDiceSize(Integer.parseInt(hitdice.nextToken()));
                continue;
            }
            if (colString.startsWith("HITDIE:")) {
                race.setHitDieLock(colString.substring(7));
                continue;
            }
            if (colString.startsWith("HITDICEADVANCEMENT:")) {
                StringTokenizer advancement = new StringTokenizer(colString.substring(19), ",");
                int[] hitDiceAdvancement = new int[advancement.countTokens()];
                for (int x = 0; x < hitDiceAdvancement.length; ++x) {
                    String temp = advancement.nextToken();
                    if (temp.length() > 0 && temp.charAt(0) == '*') {
                        race.setAdvancementUnlimited(true);
                    }
                    hitDiceAdvancement[x] = race.isAdvancementUnlimited() ? -1 : Integer.parseInt(temp);
                }
                race.setHitDiceAdvancement(hitDiceAdvancement);
                continue;
            }
            if (colString.startsWith("INIT:")) {
                race.setInitMod(new Integer(colString.substring(5)));
                continue;
            }
            if (colString.startsWith("LANGBONUS:")) {
                race.setLanguageBonus(colString.substring(10));
                continue;
            }
            if (colString.startsWith("LANGNUM:")) {
                race.setLangNum(Integer.parseInt(colString.substring(8)));
                continue;
            }
            if (colString.startsWith("LEGS:")) {
                race.setLegs(Integer.parseInt(colString.substring(5)));
                continue;
            }
            if (colString.startsWith("LEVELADJUSTMENT:")) {
                race.setLevelAdjustment(colString.substring(16));
                continue;
            }
            if (colString.startsWith("MFEAT")) {
                race.setMFeatList(colString.substring(6));
                continue;
            }
            if (colString.startsWith("MONCSKILL:")) {
                race.setMonCSkillList(colString.substring(10));
                continue;
            }
            if (colString.startsWith("MONCCSKILL:")) {
                race.setMonCCSkillList(colString.substring(11));
                continue;
            }
            if (colString.startsWith("MONSTERCLASS:")) {
                StringTokenizer mclass = new StringTokenizer(colString.substring(13), ":");
                if (mclass.countTokens() != 2) {
                    Logging.errorPrint("Illegal Monster Class info '" + colString + "' in " + source.getFile());
                }
                race.setMonsterClass(mclass.nextToken());
                race.setMonsterClassLevels(Integer.parseInt(mclass.nextToken()));
                continue;
            }
            if (colString.startsWith("PROF:")) {
                race.setWeaponProfs(colString.substring(5));
                continue;
            }
            if (colString.startsWith("QUALIFY:")) {
                race.setQualifyString(colString.substring(8));
                continue;
            }
            if (colString.startsWith("RACENAME:")) {
                race.setDisplayName(colString.substring(9));
                continue;
            }
            if (colString.startsWith("REACH:")) {
                race.setReach(Integer.parseInt(colString.substring(6)));
                continue;
            }
            if (colString.startsWith("SAVES:")) continue;
            if (colString.startsWith("SIZE:")) {
                race.setSize(colString.substring(5));
                continue;
            }
            if (colString.startsWith("SKILL:")) {
                race.setBonusSkillList(colString.substring(6));
                continue;
            }
            if (colString.startsWith("SKILLMULT:")) {
                race.setInitialSkillMultiplier(Integer.parseInt(colString.substring(10)));
                continue;
            }
            if (colString.startsWith("STARTFEATS:")) {
                race.setBonusInitialFeats(Integer.parseInt(colString.substring(11)));
                continue;
            }
            if (col < 7 || colString.startsWith("STATADJ")) {
                Logging.debugPrint("RACE: support for " + colString + " has been removed. Use ADD:BONUS|STAT instead");
                continue;
            }
            if (colString.startsWith("WEAPONBONUS:")) {
                race.setWeaponProfBonus(colString.substring(12));
                continue;
            }
            if (colString.startsWith("WEIGHT")) {
                Logging.errorPrint("WEIGHT is a deprecated tag in " + source.getFile() + ". This functionality is now handled in biosettings.lst");
                continue;
            }
            if (colString.startsWith("XTRASKILLPTSPERLVL:")) {
                race.setBonusSkillsPerLevel(Integer.parseInt(colString.substring(19)));
                continue;
            }
            if (PObjectLoader.parseTag(race, colString)) continue;
            Logging.errorPrint("Illegal race tag '" + colString + "' in " + source.getFile());
        }
        if (race.getLevelAdjustment(null) != 0 && race.getCR() == 0) {
            race.setCR(race.getLevelAdjustment(null));
        }
        this.finishObject(race);
        return null;
    }

    protected PObject getObjectNamed(String baseName) {
        return Globals.getRaceNamed(baseName);
    }

    protected void finishObject(PObject target) {
        if (this.includeObject(target)) {
            Globals.getRaceMap().put(target.getKeyName(), target);
        }
    }

    protected void performForget(PObject objToForget) {
        Globals.getRaceMap().remove(objToForget.getName());
    }
}

