/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.StringTokenizer;
import pcgen.core.GameMode;
import pcgen.core.RuleCheck;
import pcgen.util.Logging;

final class RuleCheckLoader {
    private RuleCheckLoader() {
    }

    public static void parseLine(GameMode gameMode, String aLine) {
        RuleCheck aRule = new RuleCheck();
        String inputLine = aLine.trim();
        StringTokenizer colToken = new StringTokenizer(inputLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (colString.startsWith("NAME:")) {
                aRule.setName(colString.substring(5));
                continue;
            }
            if (colString.startsWith("VAR:")) {
                aRule.setVariable(colString.substring(4));
                continue;
            }
            if (colString.startsWith("PARM:")) {
                aRule.setParameter(colString.substring(5));
                continue;
            }
            if (colString.startsWith("DEFAULT:")) {
                aRule.setDefault(colString.substring(8));
                continue;
            }
            if (colString.startsWith("EXCLUDE:")) {
                aRule.setExclude(colString.substring(8));
                continue;
            }
            if (colString.startsWith("DESC:")) {
                aRule.setDesc(colString.substring(5));
                continue;
            }
            Logging.errorPrint("Illegal Rule check: " + inputLine);
        }
        gameMode.addRule(aRule);
    }
}

