/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.SizeAdjustment;
import pcgen.core.SystemCollections;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class SizeAdjustmentLoader
extends LstLineFileLoader {
    public void loadLstFile(String fileName) throws PersistenceLayerException {
        SystemCollections.clearSizeAdjustmentList();
        super.loadLstFile(fileName);
    }

    public void parseLine(String lstLine, URL sourceURL) throws PersistenceLayerException {
        SizeAdjustment sa = new SizeAdjustment();
        String inputLine = lstLine.trim();
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (colString.startsWith("SIZENAME:")) {
                String name = colString.substring(9);
                SizeAdjustment sa2 = SystemCollections.getSizeAdjustmentNamed(name);
                if (sa2 == null) {
                    sa = new SizeAdjustment();
                    sa.setName(name);
                    SystemCollections.addToSizeAdjustmentList(sa);
                    continue;
                }
                sa = sa2;
                continue;
            }
            if (PObjectLoader.parseTag(sa, colString)) continue;
            if (colString.startsWith("ABB:")) {
                sa.setAbbreviation(colString.substring(4));
                continue;
            }
            if (colString.startsWith("ISDEFAULTSIZE:")) {
                sa.setIsDefaultSize(colString.endsWith("Y"));
                continue;
            }
            Logging.errorPrint("Illegal size info '" + lstLine + "' in " + sourceURL.toString());
        }
    }
}

