/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.Skill;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

final class SkillLoader
extends LstObjectFileLoader {
    public PObject parseLine(PObject target, String lstLine, CampaignSourceEntry source) throws PersistenceLayerException {
        Skill obj = (Skill)target;
        if (obj == null) {
            obj = new Skill();
            obj.setSourceCampaign(source.getCampaign());
            obj.setSourceFile(source.getFile());
        }
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        obj.setName(colToken.nextToken());
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (PObjectLoader.parseTag(obj, colString)) continue;
            if (colString.startsWith("ACHECK:")) {
                obj.setACheck(colString.substring(7));
                continue;
            }
            if (colString.startsWith("CLASSES:")) {
                obj.addClassList(colString.substring(8));
                continue;
            }
            if (colString.startsWith("EXCLUSIVE:")) {
                obj.setIsExclusive(colString.charAt(10) == 'Y');
                continue;
            }
            if (colString.startsWith("KEYSTAT:")) {
                obj.setKeyStat(colString.substring(8));
                continue;
            }
            if (colString.startsWith("QUALIFY:")) {
                obj.setQualifyString(colString.substring(8));
                continue;
            }
            if ("REQ".equals(colString)) {
                obj.setRequired(true);
                continue;
            }
            if (colString.startsWith("ROOT:")) {
                obj.setRootName(colString.substring(5));
                continue;
            }
            if (colString.startsWith("SYNERGY:")) {
                Logging.errorPrint("SYNERGY is a deprecated tag in " + source.toString() + ". This functionality is now handled by the BONUS tag.");
                continue;
            }
            if (colString.startsWith("USEUNTRAINED:")) {
                obj.setUntrained(colString.substring(13));
                continue;
            }
            if (colString.startsWith("VISIBLE:")) {
                String visType = colString.substring(8).toUpperCase();
                if (visType.startsWith("YES") || visType.startsWith("ALWAYS")) {
                    obj.setVisible(1);
                } else if (visType.startsWith("GUI")) {
                    obj.setVisible(3);
                } else if (visType.startsWith("EXPORT") || visType.startsWith("CSHEET")) {
                    obj.setVisible(2);
                } else {
                    Logging.errorPrint("Illegal skill info '" + colString + "' in " + source.toString());
                    obj.setVisible(1);
                }
                String[] elements = visType.split("\\|");
                if (elements.length > 1 && elements[1].equals("READONLY") && !visType.startsWith("EXPORT")) {
                    obj.setReadOnly(true);
                    continue;
                }
                Logging.errorPrint("Illegal skill info '" + colString + "' in " + source.toString());
                continue;
            }
            Logging.errorPrint("Illegal skill info '" + lstLine + "' in " + source.toString());
        }
        this.finishObject(obj);
        return null;
    }

    protected PObject getObjectNamed(String baseName) {
        return Globals.getSkillNamed(baseName);
    }

    protected void finishObject(PObject target) {
        Skill skill;
        Skill aSkill;
        if (this.includeObject(target) && (aSkill = Globals.getSkillKeyed((skill = (Skill)target).getKeyName())) == null) {
            Globals.getSkillList().add(skill);
        }
    }

    protected void performForget(PObject objToForget) {
        Globals.getSkillList().remove(objToForget);
    }
}

