/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

final class SpellLoader
extends LstObjectFileLoader {
    public PObject parseLine(PObject target, String lstLine, CampaignSourceEntry source) throws PersistenceLayerException {
        Spell obj = (Spell)target;
        if (obj == null) {
            obj = new Spell();
        }
        int i = 0;
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        while (colToken.hasMoreElements()) {
            String colString = colToken.nextToken().trim();
            int aLen = colString.length();
            if (i == 0) {
                if (!colString.equals(obj.getName()) && colString.indexOf(".MOD") < 0) {
                    this.finishObject(obj);
                    obj = new Spell();
                    obj.setName(colString);
                    obj.setSourceCampaign(source.getCampaign());
                    obj.setSourceFile(source.getFile());
                }
                ++i;
                continue;
            }
            if (colString.startsWith("CASTTIME:")) {
                obj.setCastingTime(colString.substring(9));
                continue;
            }
            if (colString.startsWith("CLASSES:")) {
                this.setLevelList(obj, "CLASS", colString.substring(8));
                continue;
            }
            if (colString.startsWith("COMPS:")) {
                obj.setComponentList(colString.substring(6));
                continue;
            }
            if (colString.startsWith("COST:")) {
                obj.setCost(colString.substring(5));
                continue;
            }
            if (colString.startsWith("DOMAINS:")) {
                this.setLevelList(obj, "DOMAIN", colString.substring(8));
                continue;
            }
            if (colString.startsWith("EFFECTS:")) {
                Logging.errorPrint("EFFECTS: tag deprecated - use DESC: instead in " + source.getFile());
                obj.setDescription(colString.substring(8));
                continue;
            }
            if (colString.startsWith("EFFECTTYPE:")) {
                Logging.errorPrint("EFFECTTYPE: tag deprecated - use TARGETAREA: instead in " + source.getFile());
                obj.setTarget(colString.substring(11));
                continue;
            }
            if (colString.startsWith("CT:")) {
                obj.setCastingThreshold(Integer.parseInt(colString.substring(3)));
                continue;
            }
            if (aLen > 11 && colString.startsWith("DESCRIPTOR")) {
                this.addDescriptors(obj, colString.substring(11));
                continue;
            }
            if (colString.startsWith("DURATION:")) {
                obj.setDuration(colString.substring(9));
                continue;
            }
            if (colString.startsWith("ITEM:")) {
                obj.setCreatableItem(colString.substring(5));
                continue;
            }
            if (colString.startsWith("QUALIFY:")) {
                obj.setQualifyString(colString.substring(8));
                continue;
            }
            if (colString.startsWith("RANGE:")) {
                obj.setRange(colString.substring(6));
                continue;
            }
            if (colString.startsWith("SAVEINFO:")) {
                obj.setSaveInfo(colString.substring(9));
                continue;
            }
            if (colString.startsWith("SCHOOL:")) {
                this.addSchools(obj, colString.substring(7));
                continue;
            }
            if (colString.startsWith("SPELLLEVEL:")) {
                Logging.errorPrint("Warning: tag 'SPELLLEVEL' has been deprecated. Use CLASSES or DOMAINS tag instead.");
                StringTokenizer slTok = new StringTokenizer(colString.substring(11), "|");
                while (slTok.countTokens() >= 3) {
                    String typeString = slTok.nextToken();
                    String mainString = slTok.nextToken();
                    obj.setLevelInfo(typeString + "|" + mainString, slTok.nextToken());
                }
                continue;
            }
            if (colString.startsWith("SPELLRES:")) {
                obj.setSpellResistance(colString.substring(9));
                continue;
            }
            if (colString.startsWith("STAT:")) {
                obj.setStat(colString.substring(5));
                continue;
            }
            if (colString.startsWith("SUBSCHOOL:")) {
                this.addSubschools(obj, colString.substring(10));
                continue;
            }
            if (colString.startsWith("TARGETAREA:")) {
                obj.setTarget(colString.substring(11));
                continue;
            }
            if (colString.startsWith("VARIANTS:")) {
                this.setVariants(obj, colString.substring(9));
                continue;
            }
            if (colString.startsWith("XPCOST:")) {
                obj.setXPCost(colString.substring(7));
                continue;
            }
            if (PObjectLoader.parseTag(obj, colString)) continue;
            Logging.errorPrint("Illegal spell info '" + colString + "' in " + source.getFile());
        }
        return obj;
    }

    protected PObject getObjectNamed(String baseName) {
        return Globals.getSpellNamed(baseName);
    }

    protected void finishObject(PObject target) {
        if (this.includeObject(target)) {
            Object obj = Globals.getSpellMap().get(target.getName());
            if (obj == null) {
                Globals.getSpellMap().put(target.getName(), target);
            } else {
                ArrayList<Object> aList;
                if (obj instanceof ArrayList) {
                    aList = (ArrayList<Object>)obj;
                } else {
                    aList = new ArrayList<Object>();
                    aList.add(obj);
                }
                boolean match = false;
                Iterator i = aList.iterator();
                while (i.hasNext()) {
                    Spell aSpell = (Spell)i.next();
                    Map a = aSpell.getLevelInfo(Globals.getCurrentPC());
                    Map b = ((Spell)target).getLevelInfo(Globals.getCurrentPC());
                    if ((a != null || b != null) && (a == null || !((Object)a).equals(b))) continue;
                    match = true;
                }
                if (!match) {
                    aList.add(target);
                    Globals.getSpellMap().put(target.getName(), aList);
                }
            }
        }
    }

    protected void performForget(PObject objToForget) {
        Globals.getSpellMap().remove(objToForget.getName());
    }

    public void addDescriptors(Spell spell, String descriptors) {
        StringTokenizer aTok = new StringTokenizer(descriptors, "|", false);
        while (aTok.hasMoreTokens()) {
            String token = aTok.nextToken();
            spell.addDescriptor(token);
            Globals.addSpellDescriptorSet(token);
        }
    }

    protected void addSubschools(Spell spell, String subschools) {
        StringTokenizer aTok = new StringTokenizer(subschools, "|", false);
        while (aTok.hasMoreTokens()) {
            String token = aTok.nextToken();
            spell.addSubschool(token);
        }
    }

    protected void addSchools(Spell spell, String schools) {
        StringTokenizer aTok = new StringTokenizer(schools, "|", false);
        while (aTok.hasMoreTokens()) {
            String token = aTok.nextToken();
            spell.addSchool(token);
        }
    }

    public void setLevelList(Spell spell, String typeString, String listString) throws PersistenceLayerException {
        if (listString.equals(".CLEAR")) {
            spell.clearLevelInfo();
            return;
        }
        String preReqTag = null;
        int i = listString.lastIndexOf(91);
        int j = listString.lastIndexOf(93);
        if (j < i) {
            j = listString.length();
        }
        if (i >= 0) {
            preReqTag = listString.substring(i + 1, j);
            listString = listString.substring(0, i);
        }
        StringTokenizer aTok = new StringTokenizer(listString, "|", false);
        while (aTok.hasMoreTokens()) {
            String aList = aTok.nextToken();
            StringTokenizer bTok = new StringTokenizer(aList, "=", false);
            while (bTok.hasMoreTokens()) {
                String nameList = bTok.nextToken();
                if (!bTok.hasMoreTokens()) {
                    throw new PersistenceLayerException("Badly formed spell " + typeString + " data: " + listString);
                }
                String aLevel = bTok.nextToken();
                StringTokenizer cTok = new StringTokenizer(nameList, ",", false);
                while (cTok.hasMoreTokens()) {
                    String aClass = cTok.nextToken();
                    if (preReqTag != null) {
                        PreParserFactory preFactory = PreParserFactory.getInstance();
                        Prerequisite prerequisite = preFactory.parse(preReqTag);
                        spell.addPreReqMapEntry(typeString + "|" + aClass, prerequisite);
                    }
                    spell.setLevelInfo(typeString + "|" + aClass, aLevel);
                }
            }
        }
    }

    public void setVariants(Spell spell, String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, "|", false);
        while (aTok.hasMoreTokens()) {
            String variant = aTok.nextToken();
            if (variant.equals(".CLEAR")) {
                spell.clearVariants();
                continue;
            }
            spell.addVariant(variant);
        }
    }
}

