/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.List;
import pcgen.core.PCStat;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.BonusSpellLoader;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.PCAlignmentLoader;
import pcgen.persistence.lst.PCCheckLoader;
import pcgen.persistence.lst.PCStatLoader;

public class StatsAndChecksLoader
extends LstLineFileLoader {
    private BonusSpellLoader bonusSpellLoader = new BonusSpellLoader();
    private PCAlignmentLoader alignmentLoader = new PCAlignmentLoader();
    private PCCheckLoader checkLoader = new PCCheckLoader();
    private PCStatLoader statLoader = new PCStatLoader();

    public void loadLstFile(String fileName) throws PersistenceLayerException {
        SettingsHandler.getGame().setAttribLong(null);
        SettingsHandler.getGame().setAttribShort(null);
        SettingsHandler.getGame().setAttribRoll(null);
        SettingsHandler.getGame().clearCheckList();
        SettingsHandler.getGame().clearAlignmentList();
        SettingsHandler.getGame().clearStatList();
        super.loadLstFile(fileName);
        List statList = SettingsHandler.getGame().getUnmodifiableStatList();
        int statCount = statList.size();
        SettingsHandler.getGame().setAttribLong(new String[statCount]);
        SettingsHandler.getGame().setAttribRoll(new boolean[statCount]);
        SettingsHandler.getGame().setAttribShort(new String[statCount]);
        for (int i = 0; i < statCount; ++i) {
            PCStat stat = (PCStat)statList.get(i);
            SettingsHandler.getGame().setAttribLong(i, stat.getName());
            SettingsHandler.getGame().setAttribRoll(i, true);
            SettingsHandler.getGame().setAttribShort(i, stat.getAbb());
        }
    }

    public void parseLine(String lstLine, URL sourceURL) throws PersistenceLayerException {
        if (lstLine.startsWith("STATNAME:")) {
            this.statLoader.parseLine(lstLine, sourceURL);
        } else if (lstLine.startsWith("CHECKNAME:")) {
            this.checkLoader.parseLine(lstLine, sourceURL);
        } else if (lstLine.startsWith("BONUSSPELLLEVEL:")) {
            this.bonusSpellLoader.parseLine(lstLine, sourceURL);
        } else if (lstLine.startsWith("ALIGNMENTNAME:")) {
            this.alignmentLoader.parseLine(lstLine, sourceURL);
        }
    }
}

