/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.StringTokenizer;
import pcgen.core.PObject;
import pcgen.core.SubClass;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.PCClassLoader;

final class SubClassLoader {
    private static PCClassLoader classLoader = new PCClassLoader();

    private SubClassLoader() {
    }

    public static PObject parseLine(PObject target, String lstLine, CampaignSourceEntry source) throws PersistenceLayerException {
        SubClass pcClass = (SubClass)target;
        if (pcClass == null) {
            return pcClass;
        }
        if (!lstLine.startsWith("SUBCLASS:")) {
            return pcClass;
        }
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (colString.startsWith("CHOICE:")) {
                pcClass.setChoice(colString.substring(7));
                continue;
            }
            if (colString.startsWith("COST:")) {
                pcClass.setCost(Integer.parseInt(colString.substring(5)));
                continue;
            }
            if (colString.startsWith("PROHIBITCOST:")) {
                pcClass.setProhibitCost(Integer.parseInt(colString.substring(13)));
                continue;
            }
            if (colString.startsWith("SUBCLASS:")) {
                pcClass.setName(colString.substring(9));
                continue;
            }
            if (colString.startsWith("SUBCLASSLEVEL:")) {
                pcClass.addToLevelArray(colString.substring(14));
                continue;
            }
            classLoader.parseLine(pcClass, colString, source);
        }
        return pcClass;
    }
}

