/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import pcgen.core.SystemCollections;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;

public class TraitLoader
extends LstLineFileLoader {
    private int traitType = -1;

    public void loadLstFile(String fileName) throws PersistenceLayerException {
        this.traitType = -1;
        super.loadLstFile(fileName);
    }

    public void parseLine(String lstLine, URL sourceURL) throws PersistenceLayerException {
        if (lstLine.charAt(0) != '[') {
            switch (this.traitType) {
                case 0: {
                    SystemCollections.addToTraitList(lstLine);
                    break;
                }
                case 1: {
                    SystemCollections.addToSpeechList(lstLine);
                    break;
                }
                case 2: {
                    SystemCollections.addToPhraseList(lstLine);
                    break;
                }
                case 3: {
                    SystemCollections.addToPhobiaList(lstLine);
                    break;
                }
                case 4: {
                    SystemCollections.addToInterestsList(lstLine);
                    break;
                }
                case 5: {
                    SystemCollections.addToHairStyleList(lstLine);
                    break;
                }
            }
        } else {
            this.traitType = lstLine.startsWith("[TRAIT]") ? 0 : (lstLine.startsWith("[SPEECH]") ? 1 : (lstLine.startsWith("[PHRASE]") ? 2 : (lstLine.startsWith("[PHOBIA]") ? 3 : (lstLine.startsWith("[INTERESTS]") ? 4 : (lstLine.startsWith("[HAIRSTYLE]") ? 5 : -1)))));
        }
    }
}

