/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URL;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.core.UnitSet;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.util.Logging;

final class UnitSetLoader
extends LstLineFileLoader {
    public void loadLstFile(String fileName) throws PersistenceLayerException {
        UnitSet units = new UnitSet();
        units.setName("Imperial");
        units.setHeightUnit("ftin");
        units.setHeightFactor(1.0);
        units.setHeightDisplayPattern("#.#");
        units.setDistanceUnit("~'");
        units.setDistanceFactor(1.0);
        units.setDistanceDisplayPattern("#");
        units.setWeightUnit("lbs.");
        units.setWeightFactor(1.0);
        units.setWeightDisplayPattern("#.###");
        SystemCollections.clearUnitSetList();
        SystemCollections.addToUnitSetList(units);
        super.loadLstFile(fileName);
        Globals.selectUnitSet(SettingsHandler.getPCGenOption("unitSetName", "Imperial"));
    }

    public void parseLine(String lstLine, URL sourceURL) throws PersistenceLayerException {
        UnitSet units = new UnitSet();
        StringTokenizer aTok = new StringTokenizer(lstLine, "\t");
        int iCount = 0;
        while (aTok.hasMoreElements()) {
            String colString = (String)aTok.nextElement();
            try {
                switch (iCount) {
                    case 0: {
                        units.setName(colString);
                        break;
                    }
                    case 1: {
                        units.setHeightUnit(colString);
                        break;
                    }
                    case 2: {
                        units.setHeightFactor(Double.parseDouble(colString));
                        break;
                    }
                    case 3: {
                        units.setHeightDisplayPattern(colString);
                        break;
                    }
                    case 4: {
                        units.setDistanceUnit(colString);
                        break;
                    }
                    case 5: {
                        units.setDistanceFactor(Double.parseDouble(colString));
                        break;
                    }
                    case 6: {
                        units.setDistanceDisplayPattern(colString);
                        break;
                    }
                    case 7: {
                        units.setWeightUnit(colString);
                        break;
                    }
                    case 8: {
                        units.setWeightFactor(Double.parseDouble(colString));
                        break;
                    }
                    case 9: {
                        units.setWeightDisplayPattern(colString);
                        break;
                    }
                    default: {
                        Logging.errorPrint("Unexpected token '" + colString + "' in " + sourceURL.toString());
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                Logging.errorPrint("Illegal unit set info '" + lstLine + "' in " + sourceURL.toString());
            }
            ++iCount;
        }
        SystemCollections.addToUnitSetList(units);
    }
}

