/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.WeaponProf;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.Logging;

public final class WeaponProfLoader
extends LstObjectFileLoader {
    public PObject parseLine(PObject target, String lstLine, CampaignSourceEntry source) throws PersistenceLayerException {
        WeaponProf obj = (WeaponProf)target;
        if (target == null) {
            obj = new WeaponProf();
        }
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        int col = 0;
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            if (PObjectLoader.parseTag(obj, colString)) continue;
            if (col == 0) {
                obj.setName(colString);
                obj.setKeyName(colString);
                obj.setSourceCampaign(source.getCampaign());
                obj.setSourceFile(source.getFile());
            } else if (colString.startsWith("HANDS")) {
                obj.setHands(colString.substring(6));
            } else if (colString.startsWith("QUALIFY:")) {
                obj.setQualifyString(colString.substring(8));
            } else {
                Logging.errorPrint("Illegal weapon proficiency info '" + lstLine + "' in " + source.toString());
            }
            ++col;
        }
        this.finishObject(obj);
        return null;
    }

    protected PObject getObjectNamed(String baseName) {
        return Globals.getWeaponProfNamed(baseName);
    }

    protected void finishObject(PObject target) {
        WeaponProf wpFromFile;
        WeaponProf wp;
        if (this.includeObject(target) && target.getName().length() > 0 && (wp = Globals.getWeaponProfNamed((wpFromFile = (WeaponProf)target).getName())) == null) {
            Globals.addWeaponProf(wpFromFile);
            target.setNewItem(false);
        }
    }

    protected void performForget(PObject objToForget) {
        Globals.removeWeaponProfNamed(objToForget.getName());
    }
}

