/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.output.prereq;

import java.io.IOException;
import java.io.Writer;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.AbstractPrerequisiteWriter;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterInterface;

public class PrerequisiteHDWriter
extends AbstractPrerequisiteWriter
implements PrerequisiteWriterInterface {
    public String kindHandled() {
        return "HD";
    }

    public PrerequisiteComparator[] operatorsHandled() {
        return new PrerequisiteComparator[]{PrerequisiteComparator.GTEQ, PrerequisiteComparator.LTEQ, PrerequisiteComparator.GT, PrerequisiteComparator.LT};
    }

    public void write(Writer writer, Prerequisite prereq) throws PersistenceLayerException {
        this.checkValidOperator(prereq, this.operatorsHandled());
        try {
            if (prereq.getOperator().equals(PrerequisiteComparator.LT) || prereq.getOperator().equals(PrerequisiteComparator.GT)) {
                writer.write("!");
            }
            writer.write("PREHD:");
            if (prereq.getOperator().equals(PrerequisiteComparator.LTEQ) || prereq.getOperator().equals(PrerequisiteComparator.GT)) {
                writer.write("0-");
                writer.write(prereq.getOperand());
            } else {
                writer.write(prereq.getOperand());
                writer.write("+");
            }
        }
        catch (IOException e) {
            throw new PersistenceLayerException(e.getMessage());
        }
    }
}

