/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.output.prereq;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.AbstractPrerequisiteWriter;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterFactory;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterInterface;

public class PrerequisiteMultWriter
extends AbstractPrerequisiteWriter
implements PrerequisiteWriterInterface {
    private boolean allSkillTot = true;

    public String kindHandled() {
        return null;
    }

    public void write(Writer writer, Prerequisite prereq) throws PersistenceLayerException {
        this.checkValidOperator(prereq, this.operatorsHandled());
        try {
            if (this.isSpecialCase(prereq)) {
                this.handleSpecialCase(writer, prereq);
                return;
            }
            if (prereq.getOperator().equals(PrerequisiteComparator.LT)) {
                writer.write("!");
            }
            writer.write("PREMULT:");
            writer.write(prereq.getOperand());
            writer.write(",");
            int i = 0;
            Iterator iter = prereq.getPrerequisites().iterator();
            while (iter.hasNext()) {
                Prerequisite subreq = (Prerequisite)iter.next();
                if (i > 0) {
                    writer.write(",");
                }
                writer.write("[");
                PrerequisiteWriterFactory factory = PrerequisiteWriterFactory.getInstance();
                PrerequisiteWriterInterface w = factory.getWriter(subreq.getKind());
                w.write(writer, subreq);
                writer.write("]");
                ++i;
            }
        }
        catch (IOException e) {
            throw new PersistenceLayerException(e.getMessage());
        }
    }

    private void handleSpecialCase(Writer writer, Prerequisite prereq) throws IOException {
        if (this.allSkillTot) {
            if (prereq.getOperator().equals(PrerequisiteComparator.LT)) {
                writer.write("!");
            }
            writer.write("PRESKILLTOT:");
            int i = 0;
            Iterator iter = prereq.getPrerequisites().iterator();
            while (iter.hasNext()) {
                Prerequisite subreq = (Prerequisite)iter.next();
                if (i > 0) {
                    writer.write(",");
                }
                writer.write(subreq.getKey());
                ++i;
            }
            writer.write("=");
            writer.write(prereq.getOperand());
        }
    }

    private boolean isSpecialCase(Prerequisite prereq) {
        this.allSkillTot = true;
        Iterator iter = prereq.getPrerequisites().iterator();
        while (iter.hasNext() && this.allSkillTot) {
            Prerequisite element = (Prerequisite)iter.next();
            if (element.getKind().equalsIgnoreCase("skill") && element.isTotalValues()) continue;
            this.allSkillTot = false;
        }
        if (this.allSkillTot) {
            return this.allSkillTot;
        }
        return false;
    }

    public PrerequisiteComparator[] operatorsHandled() {
        return new PrerequisiteComparator[]{PrerequisiteComparator.GTEQ, PrerequisiteComparator.LT};
    }
}

