/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import java.util.Iterator;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public abstract class AbstractPrerequisiteListParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    protected void convertKeysToSubKeys(Prerequisite prereq, String kind) {
        if (prereq == null) {
            return;
        }
        if (prereq.getKind() != null && prereq.getKind().equalsIgnoreCase(kind)) {
            String key = prereq.getKey();
            int index = key.indexOf("(");
            int endIndex = key.lastIndexOf(")");
            if (index > -1 && endIndex > -1) {
                String subKey = key.substring(index + 1, endIndex).trim();
                key = key.substring(0, index).trim();
                prereq.setKey(key);
                prereq.setSubKey(subKey);
            }
        }
        Iterator iter = prereq.getPrerequisites().iterator();
        while (iter.hasNext()) {
            Prerequisite element = (Prerequisite)iter.next();
            this.convertKeysToSubKeys(element, kind);
        }
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        this.parsePrereqListType(prereq, kind, formula);
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }

    protected void parsePrereqListType(Prerequisite prereq, String kind, String formula) throws PersistenceLayerException {
        String[] elements = formula.split(",|\\|");
        boolean parseOldStyle = false;
        int numRequired = 0;
        try {
            numRequired = Integer.parseInt(elements[0]);
        }
        catch (NumberFormatException nfe) {
            parseOldStyle = true;
        }
        if (parseOldStyle) {
            this.parsePrereqOldStyleList(prereq, kind, formula);
        } else if (elements.length > 2) {
            prereq.setOperator(PrerequisiteComparator.GTEQ);
            prereq.setOperand(Integer.toString(numRequired));
            prereq.setKind(null);
            int min = -99;
            for (int i = 1; i < elements.length; ++i) {
                Prerequisite subreq = new Prerequisite();
                subreq.setKind(kind.toLowerCase());
                subreq.setCountMultiples(true);
                if (elements[i].indexOf("=") > -1) {
                    subreq.setOperator(PrerequisiteComparator.GTEQ);
                    String[] tokens = elements[i].split("=");
                    try {
                        min = Integer.parseInt(tokens[1]);
                        subreq.setOperand(Integer.toString(min));
                        subreq.setKey(tokens[0]);
                        Iterator iter = prereq.getPrerequisites().iterator();
                        while (iter.hasNext()) {
                            Prerequisite element = (Prerequisite)iter.next();
                            if (!element.getOperand().equals("-99")) continue;
                            element.setOperand(Integer.toString(min));
                            if (!element.getKey().equals(tokens[0])) continue;
                            subreq = null;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        subreq.setKey(elements[i]);
                    }
                } else {
                    subreq.setKey(elements[i]);
                    subreq.setOperator(PrerequisiteComparator.GTEQ);
                    subreq.setOperand(Integer.toString(min));
                }
                if (subreq == null) continue;
                subreq.setOperand(Integer.toString(min));
                prereq.addPrerequisite(subreq);
            }
            Iterator iter = prereq.getPrerequisites().iterator();
            while (iter.hasNext()) {
                Prerequisite element = (Prerequisite)iter.next();
                if (!element.getOperand().equals("-99")) continue;
                element.setOperand("1");
            }
        } else {
            prereq.setKind(kind.toLowerCase());
            if (elements.length > 1) {
                if (elements[1].indexOf("=") > -1) {
                    String[] tokens = elements[1].split("=");
                    try {
                        prereq.setOperand(Integer.toString(Integer.parseInt(tokens[1])));
                        prereq.setKey(tokens[0]);
                    }
                    catch (NumberFormatException nfe) {
                        prereq.setKey(elements[1]);
                    }
                } else {
                    prereq.setKey(elements[1]);
                }
            }
            if (prereq.getOperand().equals("1")) {
                prereq.setOperand(elements[0]);
            }
            prereq.setOperator(PrerequisiteComparator.GTEQ);
        }
    }

    protected void parsePrereqOldStyleList(Prerequisite prereq, String kind, String formula) throws PersistenceLayerException {
        String[] templates = formula.split(",|\\|");
        if (templates.length == 1) {
            int min = 1;
            String[] lastElements = templates[0].split("=");
            if (lastElements.length == 2) {
                try {
                    min = Integer.parseInt(lastElements[1]);
                    templates[0] = lastElements[0];
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            prereq.setKind(kind.toLowerCase());
            prereq.setKey(templates[0]);
            prereq.setOperator(PrerequisiteComparator.GTEQ);
            prereq.setOperand(String.valueOf(min));
        } else {
            prereq.setKind(null);
            prereq.setOperator(PrerequisiteComparator.GTEQ);
            prereq.setOperand("1");
            for (int i = 0; i < templates.length; ++i) {
                Prerequisite subPrereq = new Prerequisite();
                subPrereq.setKind(kind.toLowerCase());
                subPrereq.setKey(templates[i]);
                prereq.addPrerequisite(subPrereq);
            }
        }
    }
}

