/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import pcgen.core.GameMode;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreAlignParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"align"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        String[] alignments = formula.split(",");
        GameMode gm = SettingsHandler.getGame();
        String[] validAlignments = gm.getAlignmentListStrings(false);
        if (validAlignments.length == 0) {
            prereq.setKey("");
            prereq.setOperator(PrerequisiteComparator.EQ);
        } else if (alignments.length == 1) {
            prereq.setKey(this.convertFromNumber(formula, validAlignments));
            prereq.setOperator(PrerequisiteComparator.EQ);
        } else {
            prereq.setKind(null);
            prereq.setOperator(PrerequisiteComparator.GTEQ);
            prereq.setOperand("1");
            for (int i = 0; i < alignments.length; ++i) {
                Prerequisite subreq = new Prerequisite();
                subreq.setKind("align");
                subreq.setKey(this.convertFromNumber(alignments[i], validAlignments));
                subreq.setOperator(PrerequisiteComparator.EQ);
                prereq.addPrerequisite(subreq);
            }
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }

    private String convertFromNumber(String string, String[] validAlignments) {
        try {
            int alignInt = Integer.parseInt(string);
            return validAlignments[alignInt];
        }
        catch (NumberFormatException e) {
            return string;
        }
    }
}

