/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import java.util.Iterator;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteListParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreClassLevelMaxParser
extends AbstractPrerequisiteListParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"CLASSLEVELMAX"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        if ("classlevelmax".equals(prereq.getKind())) {
            prereq.setKind("class");
            prereq.setOperator(PrerequisiteComparator.LTEQ);
            if (invertResult) {
                prereq.setOperator(prereq.getOperator().invert());
            }
        } else {
            String[] elements = formula.split(",|\\|");
            boolean parseOldStyle = false;
            int numRequired = 0;
            try {
                numRequired = Integer.parseInt(elements[0]);
            }
            catch (NumberFormatException nfe) {
                prereq.setOperand(String.valueOf(prereq.getPrerequisites().size()));
            }
            Iterator iter = prereq.getPrerequisites().iterator();
            while (iter.hasNext()) {
                Prerequisite element = (Prerequisite)iter.next();
                element.setKind("class");
                element.setOperator(PrerequisiteComparator.LTEQ);
                if (!invertResult) continue;
                element.setOperator(element.getOperator().invert());
            }
        }
        return prereq;
    }
}

