/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import java.util.StringTokenizer;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreDamageReductionParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"DR"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        prereq.setKind(null);
        StringTokenizer inputTokenizer = new StringTokenizer(formula, ",");
        String tok = inputTokenizer.nextToken();
        try {
            prereq.setOperand(Integer.toString(Integer.parseInt(tok)));
        }
        catch (NumberFormatException exc) {
            throw new PersistenceLayerException("Badly formed passesPreDR/number of DRs attribute: " + tok);
        }
        while (inputTokenizer.hasMoreTokens()) {
            int drValue;
            StringTokenizer inputDRTokenizer = new StringTokenizer(inputTokenizer.nextToken(), "=.");
            String drType = inputDRTokenizer.nextToken();
            if (inputDRTokenizer.hasMoreTokens()) {
                try {
                    drValue = Integer.parseInt(inputDRTokenizer.nextToken());
                }
                catch (NumberFormatException nfe) {
                    throw new PersistenceLayerException("Badly formed passesPreDR value: " + formula);
                }
            } else {
                drValue = 0;
            }
            Prerequisite subprereq = new Prerequisite();
            subprereq.setKind("dr");
            subprereq.setKey(drType);
            subprereq.setOperand(Integer.toString(drValue));
            prereq.addPrerequisite(subprereq);
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }
}

