/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import java.util.StringTokenizer;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreDeityAlignParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"DEITYALIGN"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        prereq.setKind(null);
        StringTokenizer inputTokenizer = new StringTokenizer(formula, ",");
        while (inputTokenizer.hasMoreTokens()) {
            Prerequisite subprereq = new Prerequisite();
            prereq.addPrerequisite(subprereq);
            subprereq.setKind("deity.align");
            subprereq.setOperator(PrerequisiteComparator.EQ);
            String token = inputTokenizer.nextToken();
            try {
                subprereq.setOperand(SettingsHandler.getGame().getShortAlignmentAtIndex(Integer.parseInt(token)));
            }
            catch (NumberFormatException e) {
                throw new PersistenceLayerException("Badly formed PREDEITYALIGN attribute: '" + token + "' should be an integer");
            }
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }
}

