/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreHitDiceParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"HD"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq;
        block5: {
            prereq = super.parse(kind, formula, invertResult, overrideQualify);
            String[] tokens = formula.split("\\+|-");
            try {
                if (tokens.length == 1 || tokens.length == 2 && !tokens[1].equals("")) {
                    int min = Integer.parseInt(tokens[0]);
                    prereq.setOperand(Integer.toString(min));
                    prereq.setOperator(PrerequisiteComparator.GTEQ);
                    break block5;
                }
                if (tokens.length == 2) {
                    int min = Integer.parseInt(tokens[0]);
                    int max = Integer.parseInt(tokens[1]);
                    Prerequisite minPrereq = new Prerequisite();
                    minPrereq.setKind("hd");
                    minPrereq.setOperator(PrerequisiteComparator.GTEQ);
                    minPrereq.setOperand(Integer.toString(min));
                    Prerequisite maxPrereq = new Prerequisite();
                    maxPrereq.setKind("hd");
                    maxPrereq.setOperator(PrerequisiteComparator.LTEQ);
                    maxPrereq.setOperand(Integer.toString(max));
                    prereq.setKind(null);
                    prereq.setOperand("2");
                    prereq.addPrerequisite(minPrereq);
                    prereq.addPrerequisite(maxPrereq);
                    break block5;
                }
                throw new PersistenceLayerException("PREHD must be either 'x+' or 'x-y' where 'x' and 'y' are integers. '" + formula + "' is not valid ");
            }
            catch (NumberFormatException nfe) {
                throw new PersistenceLayerException("PREHD must be either 'x+' or 'x-y' where 'x' and 'y' are integers. '" + formula + "' is not valid ");
            }
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }
}

