/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreMoveParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"MOVE"};
    }

    protected Prerequisite getSingleMovePrereq(String moveTokens) {
        Prerequisite subreq = new Prerequisite();
        subreq.setKind("move");
        subreq.setOperator(PrerequisiteComparator.GTEQ);
        if (moveTokens.indexOf(46) > -1 || moveTokens.indexOf(61) > -1) {
            String[] strings = moveTokens.split("=|\\.");
            subreq.setKey(strings[0]);
            subreq.setOperand(strings[1]);
        } else {
            subreq.setKey(moveTokens);
            subreq.setOperand("0");
        }
        return subreq;
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        prereq.setKind(null);
        String[] tokens = formula.split(",");
        if (tokens.length == 1) {
            prereq = this.getSingleMovePrereq(tokens[0]);
        } else {
            for (int i = 0; i < tokens.length; ++i) {
                Prerequisite subreq = this.getSingleMovePrereq(tokens[i]);
                prereq.addPrerequisite(subreq);
            }
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }
}

