/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PreParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreMultParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"MULT"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        prereq.setKind(null);
        int commaIndex = formula.indexOf(",");
        if (commaIndex > 0) {
            String minFormula = formula.substring(0, commaIndex);
            formula = formula.substring(commaIndex + 1);
            prereq.setOperator(PrerequisiteComparator.GTEQ);
            prereq.setOperand(minFormula);
        }
        List subList = this.splitOnTopLevelToken(formula, '[', ']');
        Iterator itr = subList.iterator();
        while (itr.hasNext()) {
            PreParser parser = new PreParser();
            prereq.addPrerequisite(parser.parse((String)itr.next()));
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }

    protected List splitOnTopLevelToken(String input, char startDelimiter, char endDelimiter) {
        int nesting = 0;
        int startIndex = 0;
        int currIndex = 0;
        ArrayList<String> subList = new ArrayList<String>();
        for (currIndex = 0; currIndex < input.length(); ++currIndex) {
            char currChar = input.charAt(currIndex);
            if (currChar == ',' && nesting == 0) {
                String subPre = input.substring(startIndex + 1, currIndex - 1);
                startIndex = currIndex + 1;
                subList.add(subPre);
            }
            if (currChar == startDelimiter) {
                ++nesting;
            }
            if (currChar != endDelimiter) continue;
            --nesting;
        }
        subList.add(input.substring(startIndex + 1, currIndex - 1));
        return subList;
    }
}

