/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import java.util.HashMap;
import java.util.Map;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreAlignParser;
import pcgen.persistence.lst.prereq.PreApplyParser;
import pcgen.persistence.lst.prereq.PreArmorProfParser;
import pcgen.persistence.lst.prereq.PreArmorTypeParser;
import pcgen.persistence.lst.prereq.PreAttackParser;
import pcgen.persistence.lst.prereq.PreBaseSizeParser;
import pcgen.persistence.lst.prereq.PreBirthplaceParser;
import pcgen.persistence.lst.prereq.PreCheckParser;
import pcgen.persistence.lst.prereq.PreCityParser;
import pcgen.persistence.lst.prereq.PreClassLevelMaxParser;
import pcgen.persistence.lst.prereq.PreClassParser;
import pcgen.persistence.lst.prereq.PreDamageReductionParser;
import pcgen.persistence.lst.prereq.PreDefaultMonsterParser;
import pcgen.persistence.lst.prereq.PreDeityAlignParser;
import pcgen.persistence.lst.prereq.PreDeityDomainParser;
import pcgen.persistence.lst.prereq.PreDeityParser;
import pcgen.persistence.lst.prereq.PreDomainParser;
import pcgen.persistence.lst.prereq.PreEquipParser;
import pcgen.persistence.lst.prereq.PreEquippedBothParser;
import pcgen.persistence.lst.prereq.PreEquippedPrimaryParser;
import pcgen.persistence.lst.prereq.PreEquippedSecondaryParser;
import pcgen.persistence.lst.prereq.PreEquippedTwoWeaponParser;
import pcgen.persistence.lst.prereq.PreFeatParser;
import pcgen.persistence.lst.prereq.PreGenderParser;
import pcgen.persistence.lst.prereq.PreHandsParser;
import pcgen.persistence.lst.prereq.PreHitDiceParser;
import pcgen.persistence.lst.prereq.PreHitPointsParser;
import pcgen.persistence.lst.prereq.PreItemParser;
import pcgen.persistence.lst.prereq.PreLanguageParser;
import pcgen.persistence.lst.prereq.PreLegsParser;
import pcgen.persistence.lst.prereq.PreLevelMaxParser;
import pcgen.persistence.lst.prereq.PreLevelParser;
import pcgen.persistence.lst.prereq.PreMoveParser;
import pcgen.persistence.lst.prereq.PreMultParser;
import pcgen.persistence.lst.prereq.PreRaceParser;
import pcgen.persistence.lst.prereq.PreRegionParser;
import pcgen.persistence.lst.prereq.PreRuleParser;
import pcgen.persistence.lst.prereq.PreShieldProficiencyParser;
import pcgen.persistence.lst.prereq.PreSizeParser;
import pcgen.persistence.lst.prereq.PreSkillParser;
import pcgen.persistence.lst.prereq.PreSkillTotalParser;
import pcgen.persistence.lst.prereq.PreSpecialAbilityParser;
import pcgen.persistence.lst.prereq.PreSpellBookParser;
import pcgen.persistence.lst.prereq.PreSpellCastParser;
import pcgen.persistence.lst.prereq.PreSpellDescriptorParser;
import pcgen.persistence.lst.prereq.PreSpellParser;
import pcgen.persistence.lst.prereq.PreSpellResistanceParser;
import pcgen.persistence.lst.prereq.PreSpellSchoolParser;
import pcgen.persistence.lst.prereq.PreSpellSchoolSubParser;
import pcgen.persistence.lst.prereq.PreSpellTypeParser;
import pcgen.persistence.lst.prereq.PreStatParser;
import pcgen.persistence.lst.prereq.PreSubClassParser;
import pcgen.persistence.lst.prereq.PreTemplateParser;
import pcgen.persistence.lst.prereq.PreTextParser;
import pcgen.persistence.lst.prereq.PreTypeParser;
import pcgen.persistence.lst.prereq.PreUnarmedAttackParser;
import pcgen.persistence.lst.prereq.PreVariableParser;
import pcgen.persistence.lst.prereq.PreVisionParser;
import pcgen.persistence.lst.prereq.PreWeaponProficiencyParser;
import pcgen.persistence.lst.prereq.PreWieldParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreParserFactory {
    private static PreParserFactory instance = null;
    private static Map parserLookup = new HashMap();

    private PreParserFactory() throws PersistenceLayerException {
        this.register(new PreAlignParser());
        this.register(new PreApplyParser());
        this.register(new PreArmorProfParser());
        this.register(new PreArmorTypeParser());
        this.register(new PreAttackParser());
        this.register(new PreBaseSizeParser());
        this.register(new PreBirthplaceParser());
        this.register(new PreCityParser());
        this.register(new PreCheckParser());
        this.register(new PreClassParser());
        this.register(new PreClassLevelMaxParser());
        this.register(new PreDamageReductionParser());
        this.register(new PreDefaultMonsterParser());
        this.register(new PreDeityParser());
        this.register(new PreDeityAlignParser());
        this.register(new PreDeityDomainParser());
        this.register(new PreDomainParser());
        this.register(new PreEquipParser());
        this.register(new PreEquippedBothParser());
        this.register(new PreEquippedPrimaryParser());
        this.register(new PreEquippedSecondaryParser());
        this.register(new PreEquippedTwoWeaponParser());
        this.register(new PreFeatParser());
        this.register(new PreGenderParser());
        this.register(new PreHandsParser());
        this.register(new PreHitDiceParser());
        this.register(new PreHitPointsParser());
        this.register(new PreItemParser());
        this.register(new PreLanguageParser());
        this.register(new PreLegsParser());
        this.register(new PreLevelParser());
        this.register(new PreLevelMaxParser());
        this.register(new PreMoveParser());
        this.register(new PreMultParser());
        this.register(new PreRaceParser());
        this.register(new PreRegionParser());
        this.register(new PreRuleParser());
        this.register(new PreShieldProficiencyParser());
        this.register(new PreSizeParser());
        this.register(new PreSkillParser());
        this.register(new PreSkillTotalParser());
        this.register(new PreSpellParser());
        this.register(new PreSpecialAbilityParser());
        this.register(new PreSpellBookParser());
        this.register(new PreSpellCastParser());
        this.register(new PreSpellDescriptorParser());
        this.register(new PreSpellResistanceParser());
        this.register(new PreSpellSchoolParser());
        this.register(new PreSpellSchoolSubParser());
        this.register(new PreSpellTypeParser());
        this.register(new PreStatParser());
        this.register(new PreSubClassParser());
        this.register(new PreTemplateParser());
        this.register(new PreTextParser());
        this.register(new PreTypeParser());
        this.register(new PreUnarmedAttackParser());
        this.register(new PreVariableParser());
        this.register(new PreVisionParser());
        this.register(new PreWieldParser());
        this.register(new PreWeaponProficiencyParser());
    }

    public static PreParserFactory getInstance() throws PersistenceLayerException {
        if (instance == null) {
            instance = new PreParserFactory();
        }
        return instance;
    }

    public PrerequisiteParserInterface getParser(String kind) {
        PrerequisiteParserInterface test = (PrerequisiteParserInterface)parserLookup.get(kind.toLowerCase());
        return test;
    }

    private void register(PrerequisiteParserInterface testClass) throws PersistenceLayerException {
        String[] kindsHandled = testClass.kindsHandled();
        for (int i = 0; i < kindsHandled.length; ++i) {
            Object test = parserLookup.get(kindsHandled[i].toLowerCase());
            if (test != null) {
                throw new PersistenceLayerException("Error registering '" + testClass.getClass().getName() + "' as test '" + kindsHandled[i] + "'. The test is already registered to '" + test.getClass().getName() + "'");
            }
            parserLookup.put(kindsHandled[i].toLowerCase(), testClass);
        }
    }

    public Prerequisite parse(String prereqStr) throws PersistenceLayerException {
        PrerequisiteParserInterface parser;
        if (prereqStr == null || prereqStr.length() <= 0) {
            throw new PersistenceLayerException("Null or empty PRE string");
        }
        int index = prereqStr.indexOf(":");
        if (index < 0) {
            throw new PersistenceLayerException("'" + prereqStr + "'" + " is a badly formatted prereq.");
        }
        String kind = prereqStr.substring(0, index);
        String formula = prereqStr.substring(index + 1);
        if ("pre".equals(kind.toLowerCase()) && ".clear".equals(formula.toLowerCase())) {
            Prerequisite prereq = new Prerequisite();
            prereq.setKind("clear");
            return prereq;
        }
        boolean overrideQualify = false;
        if (formula.startsWith("Q:")) {
            formula = formula.substring(2);
            overrideQualify = true;
        }
        boolean invertResult = false;
        if (kind.startsWith("!")) {
            invertResult = true;
            kind = kind.substring(1);
        }
        if ((parser = this.getParser(kind = kind.substring(3))) == null) {
            throw new PersistenceLayerException("Can not determine which parser to use for '" + prereqStr + "'");
        }
        try {
            Prerequisite prereq = parser.parse(kind, formula, invertResult, false);
            while (prereq.getKind() == null && prereq.getPrerequisites().size() == 1 && prereq.getOperator().equals(PrerequisiteComparator.GTEQ) && prereq.getOperand().equals("1")) {
                prereq = (Prerequisite)prereq.getPrerequisites().get(0);
            }
            return prereq;
        }
        catch (Throwable t) {
            throw new PersistenceLayerException("Can not parse '" + prereqStr + "': " + t.getMessage());
        }
    }
}

