/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreSizeParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"SIZEEQ", "SIZEGT", "SIZEGTEQ", "SIZELT", "SIZELTEQ", "SIZENEQ"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        try {
            prereq.setKind("size");
            String compType = kind.substring(4).toLowerCase();
            if (compType.length() == 0) {
                compType = "gteq";
            }
            prereq.setOperator(compType);
            prereq.setOperand(formula);
            if (invertResult) {
                prereq.setOperator(prereq.getOperator().invert());
            }
        }
        catch (PrerequisiteException pe) {
            throw new PersistenceLayerException("Unable to parse the prerequisite :'" + kind + ":" + formula + "'. " + pe.getLocalizedMessage());
        }
        return prereq;
    }
}

