/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import java.util.StringTokenizer;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreSpellCastParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"SPELLCAST"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        prereq.setKind(null);
        StringTokenizer inputTokenizer = new StringTokenizer(formula, ",");
        while (inputTokenizer.hasMoreTokens()) {
            Prerequisite subprereq;
            String token = inputTokenizer.nextToken();
            if (token.startsWith("MEMORIZE")) {
                subprereq = new Prerequisite();
                prereq.addPrerequisite(subprereq);
                subprereq.setKind("spellcast.memorize");
                subprereq.setOperator(PrerequisiteComparator.EQ);
                String[] elements = token.split("=");
                if (elements[1].startsWith("N")) {
                    subprereq.setKey("N");
                    continue;
                }
                subprereq.setKey("Y");
                continue;
            }
            if (!token.startsWith("TYPE")) continue;
            subprereq = new Prerequisite();
            prereq.addPrerequisite(subprereq);
            subprereq.setKind("spellcast.type");
            subprereq.setOperator(PrerequisiteComparator.EQ);
            subprereq.setKey(token.substring(5));
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }
}

