/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreSpellTypeParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"SPELLTYPE"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        prereq.setKind("spell.type");
        String[] elements = formula.split(",");
        if (elements.length != 3) {
            throw new PersistenceLayerException("PRESPELLTYPE must have exactly 3 elements: '" + formula + "' is not valid");
        }
        String[] types = elements[0].split("\\|");
        if (types.length == 1) {
            prereq.setKey(elements[0]);
            prereq.setSubKey(elements[2]);
            prereq.setOperator(PrerequisiteComparator.GTEQ);
            prereq.setOperand(elements[1]);
        } else {
            prereq.setKind(null);
            for (int i = 0; i < types.length; ++i) {
                Prerequisite subreq = new Prerequisite();
                prereq.addPrerequisite(subreq);
                subreq.setKind("spell.type");
                subreq.setKey(types[i]);
                subreq.setSubKey(elements[2]);
                subreq.setOperator(PrerequisiteComparator.GTEQ);
                subreq.setOperand(elements[1]);
            }
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }
}

