/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.util.Logging;

public class PreStatParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"STAT", "STATEQ", "STATGT", "STATGTEQ", "STATLT", "STATLTEQ", "STATNEQ"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        try {
            prereq.setKind(null);
            String compType = kind.substring(4).toLowerCase();
            if (compType.length() == 0) {
                compType = "gteq";
            }
            String[] tokens = formula.split(",|\\|");
            int currToken = 0;
            String aString = tokens[currToken++];
            try {
                prereq.setOperand(Integer.toString(Integer.parseInt(aString)));
            }
            catch (NumberFormatException e) {
                Logging.errorPrint("Badly formed passesPreStat attribute: " + aString);
                prereq.setOperand("1");
            }
            while (currToken < tokens.length) {
                if ((aString = tokens[currToken++]).length() < 3) {
                    Logging.errorPrint("Badly formed PRESTAT token: " + formula);
                    return null;
                }
                String stat = aString.substring(0, 3);
                Prerequisite statPrereq = new Prerequisite();
                statPrereq.setKind("stat");
                statPrereq.setKey(stat);
                statPrereq.setOperator(compType);
                statPrereq.setOperand(aString.substring(aString.lastIndexOf(61) + 1));
                prereq.addPrerequisite(statPrereq);
            }
            if (invertResult) {
                prereq.setOperator(prereq.getOperator().invert());
            }
        }
        catch (PrerequisiteException pe) {
            throw new PersistenceLayerException("Unable to parse the prerequisite :'" + kind + ":" + formula + "'. " + pe.getLocalizedMessage());
        }
        return prereq;
    }
}

