/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import java.util.StringTokenizer;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreTypeParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"TYPE"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        int aNum = 1;
        StringTokenizer aTok = new StringTokenizer(formula, ",");
        String aString = aTok.nextToken();
        try {
            aNum = Integer.parseInt(aString);
        }
        catch (NumberFormatException nfe) {
            return this.parseOldPreType(kind, formula, invertResult);
        }
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        prereq.setOperand(Integer.toString(aNum));
        prereq.setKind(null);
        while (aTok.hasMoreTokens()) {
            Prerequisite subreq = new Prerequisite();
            subreq.setOperator(PrerequisiteComparator.EQ);
            subreq.setKind("type");
            subreq.setKey(aTok.nextToken());
            prereq.addPrerequisite(subreq);
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }

    protected Prerequisite parseOldPreType(String kind, String formula, boolean invertResult) throws PersistenceLayerException {
        String[] andTokens = formula.split(",");
        Prerequisite prereq = new Prerequisite();
        prereq.setOperator(PrerequisiteComparator.EQ);
        prereq.setOperand(Integer.toString(andTokens.length));
        for (int i = 0; i < andTokens.length; ++i) {
            String andToken = andTokens[i];
            Prerequisite andPrereq = new Prerequisite();
            prereq.addPrerequisite(andPrereq);
            if (andToken.indexOf(124) > -1) {
                String[] orTokens = andToken.split("\\|");
                andPrereq.setOperand("1");
                andPrereq.setOperator(PrerequisiteComparator.GTEQ);
                for (int j = 0; j < orTokens.length; ++j) {
                    String orToken = orTokens[j];
                    Prerequisite orPrereq = new Prerequisite();
                    andPrereq.addPrerequisite(orPrereq);
                    orPrereq.setKind("type");
                    if (orToken.startsWith("[")) {
                        orPrereq.setKey(orToken.substring(1, orToken.length() - 1));
                        orPrereq.setOperand("1");
                        orPrereq.setOperator(PrerequisiteComparator.NEQ);
                        continue;
                    }
                    orPrereq.setKey(orToken);
                    orPrereq.setOperand("1");
                    orPrereq.setOperator(PrerequisiteComparator.EQ);
                }
                continue;
            }
            andPrereq.setKind("type");
            if (andToken.startsWith("[")) {
                andPrereq.setKey(andToken.substring(1, andToken.length() - 1));
                andPrereq.setOperand("1");
                andPrereq.setOperator(PrerequisiteComparator.NEQ);
                continue;
            }
            andPrereq.setKey(andToken);
            andPrereq.setOperand("1");
            andPrereq.setOperator(PrerequisiteComparator.EQ);
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }
}

