/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreVariableParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"VAR", "VAREQ", "VARLTEQ", "VARLT", "VARNEQ", "VARGT", "VARGTEQ"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        prereq.setKind("var");
        String compType = kind.substring(3).toLowerCase();
        if (compType.length() == 0) {
            compType = "gteq";
        }
        String[] tokens = formula.split(",|\\|");
        try {
            prereq.setOperator(compType);
            prereq.setKey(tokens[0]);
            prereq.setOperand(tokens[1]);
        }
        catch (PrerequisiteException pe) {
            throw new PersistenceLayerException("Unable to parse prrequisite 'PRE" + kind + ":" + formula + "'. " + pe.getLocalizedMessage());
        }
        if (tokens.length > 3) {
            for (int i = 2; i < tokens.length; ++i) {
                String andKey = tokens[i];
                String andOp = tokens[++i];
                Prerequisite andPrereq = new Prerequisite();
                try {
                    prereq.addPrerequisite(andPrereq);
                    andPrereq.setKind("var");
                    andPrereq.setOperator(compType);
                    andPrereq.setKey(andKey);
                    andPrereq.setOperand(andOp);
                    continue;
                }
                catch (PrerequisiteException pe) {
                    throw new PersistenceLayerException("Unable to parse prrequisite 'PRE" + kind + ":" + formula + "'. " + pe.getLocalizedMessage());
                }
            }
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        prereq.setOverrideQualify(overrideQualify);
        return prereq;
    }
}

