/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

public class FeatParser {
    public static List parseVirtualFeatList(String aString) {
        Feat aFeat;
        String preString = "";
        LinkedList<Feat> aList = new LinkedList<Feat>();
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        while (aTok.hasMoreTokens()) {
            String aPart = aTok.nextToken();
            if (aPart.length() <= 0) continue;
            if ((aPart.startsWith("PRE") || aPart.startsWith("!PRE")) && aPart.indexOf(":") > 0) {
                preString = aPart;
                continue;
            }
            aFeat = Globals.getFeatNamed(aPart);
            if (aFeat == null) continue;
            aFeat = (Feat)aFeat.clone();
            aFeat.setFeatType(2);
            if (!aFeat.getName().equalsIgnoreCase(aPart)) {
                int i = aPart.indexOf(40);
                int j = aPart.indexOf(41);
                if (i >= 0 && j >= 0) {
                    StringTokenizer bTok = new StringTokenizer(aPart.substring(i + 1, j), ",");
                    while (bTok.hasMoreTokens()) {
                        String a = bTok.nextToken();
                        if (aFeat.containsAssociated(a)) continue;
                        aFeat.addAssociated(a);
                    }
                }
            }
            aList.add(aFeat);
        }
        if (preString.length() > 0 && !aList.isEmpty()) {
            Iterator e = aList.iterator();
            while (e.hasNext()) {
                aFeat = (Feat)e.next();
                try {
                    PreParserFactory factory = PreParserFactory.getInstance();
                    Prerequisite prereq = factory.parse(preString);
                    aFeat.addPreReq(prereq);
                }
                catch (PersistenceLayerException ple) {
                    Logging.errorPrint(ple.getMessage(), ple);
                }
            }
        }
        return aList;
    }
}

