/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.math.BigDecimal;
import pcgen.core.Globals;
import pcgen.util.Logging;

public class BigDecimalHelper {
    public static final BigDecimal ZERO = new BigDecimal(0.0);

    public static BigDecimal formatBigDecimal(BigDecimal n, int dp) {
        return n.setScale(dp, 4);
    }

    public static BigDecimal trimBigDecimal(BigDecimal n) {
        if (Globals.javaVersionMajor != 1 || Globals.javaVersionMinor != 5) {
            try {
                while (true) {
                    n = n.setScale(n.scale() - 1);
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return n;
    }

    public static String trimZeros(String numberToTrim) {
        BigDecimal aBigD = ZERO;
        try {
            aBigD = new BigDecimal(numberToTrim);
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("Cannot trim zeroes from " + numberToTrim + " as is not a number. Using 0 instead.");
        }
        return BigDecimalHelper.trimBigDecimal(aBigD).toString();
    }

    public static String trimZeros(BigDecimal n) {
        return BigDecimalHelper.trimBigDecimal(n).toString();
    }
}

