/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOInputHandler;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.apps.XSLTInputHandler;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.SecureResourceBundle;
import org.apache.fop.viewer.Translator;
import org.xml.sax.XMLReader;
import pcgen.core.Constants;
import pcgen.util.Logging;

public final class FOPHandler
implements Runnable {
    public static final int PDF_MODE = 0;
    public static final int AWT_MODE = 1;
    private Driver driver = new Driver();
    private File outFile = null;
    private FileOutputStream fos;
    private InputHandler inputHandler = null;
    private Renderer renderer = null;
    private StringBuffer errBuffer = new StringBuffer();
    private int mode = 0;

    public String getErrorMessage() {
        return this.errBuffer.toString();
    }

    public void setInputFile(File in) {
        try {
            if (in == null) {
                throw new NullPointerException("XML file must be specified for the tranform mode");
            }
            if (!in.exists()) {
                throw new FileNotFoundException("xml file " + in.getAbsolutePath() + " not found ");
            }
            this.inputHandler = new FOInputHandler(in);
        }
        catch (FileNotFoundException e) {
            this.errBuffer.append(e.getMessage()).append(Constants.s_LINE_SEP);
            Logging.errorPrint("Exception in FOPHandler:setInputFile", e);
        }
    }

    public void setInputFile(File xmlFile, File xsltFile) {
        try {
            if (xmlFile == null) {
                throw new NullPointerException("XML file must be specified for the tranform mode");
            }
            if (xsltFile == null) {
                throw new NullPointerException("XSLT file must be specified for the tranform mode");
            }
            if (!xmlFile.exists()) {
                throw new FileNotFoundException("xml file " + xmlFile.getAbsolutePath() + " not found ");
            }
            if (!xsltFile.exists()) {
                throw new FileNotFoundException("xsl file " + xsltFile.getAbsolutePath() + " not found ");
            }
            this.inputHandler = new XSLTInputHandler(xmlFile, xsltFile);
        }
        catch (FileNotFoundException e) {
            this.errBuffer.append(e.getMessage()).append(Constants.s_LINE_SEP);
            Logging.errorPrint("Exception in FOPHandler:setInputFile", e);
        }
        catch (NullPointerException e) {
            this.errBuffer.append(e.getMessage()).append(Constants.s_LINE_SEP);
            Logging.errorPrint("Exception in FOPHandler:setInputFile", e);
        }
        catch (FOPException e) {
            this.errBuffer.append(e.getMessage()).append(Constants.s_LINE_SEP);
            Logging.errorPrint("Exception in FOPHandler:setInputFile", e);
        }
    }

    public void setMode(int m) {
        this.mode = m;
    }

    public void setOutputFile(File out) {
        this.outFile = out;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        this.errBuffer.delete(0, this.errBuffer.length());
        this.driver.reset();
        if (this.mode == 0) {
            this.fos = null;
            this.renderer = null;
            this.driver.setRenderer(1);
            XMLReader parser = this.inputHandler.getParser();
            HashMap<String, Boolean> rendererOptions = new HashMap<String, Boolean>();
            rendererOptions.put("fineDetail", false);
            this.driver.getRenderer().setOptions(rendererOptions);
            this.driver.getRenderer().setProducer("PC Gen Character Generator");
            this.fos = new FileOutputStream(this.outFile);
            this.driver.setOutputStream((OutputStream)this.fos);
            this.driver.render(parser, this.inputHandler.getInputSource());
            Object var4_7 = null;
            if (this.fos == null) return;
            try {
                this.fos.close();
                return;
            }
            catch (IOException ioex) {
                this.errBuffer.append(ioex.getMessage()).append(Constants.s_LINE_SEP);
                Logging.errorPrint("Exception in FOPHandler:run", ioex);
            }
            return;
            {
                catch (FOPException fopex) {
                    this.errBuffer.append(fopex.getMessage()).append(Constants.s_LINE_SEP);
                    Logging.errorPrint("Exception in FOPHandler:run", fopex);
                    Object var4_8 = null;
                    if (this.fos == null) return;
                    try {
                        this.fos.close();
                        return;
                    }
                    catch (IOException ioex) {
                        this.errBuffer.append(ioex.getMessage()).append(Constants.s_LINE_SEP);
                        Logging.errorPrint("Exception in FOPHandler:run", ioex);
                    }
                    return;
                }
                catch (FileNotFoundException fnfex) {
                    this.errBuffer.append(fnfex.getMessage()).append(Constants.s_LINE_SEP);
                    Logging.errorPrint("Exception in FOPHandler:run, cannot find file: " + fnfex.getMessage());
                    Object var4_9 = null;
                    if (this.fos == null) return;
                    try {
                        this.fos.close();
                        return;
                    }
                    catch (IOException ioex) {
                        this.errBuffer.append(ioex.getMessage()).append(Constants.s_LINE_SEP);
                        Logging.errorPrint("Exception in FOPHandler:run", ioex);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_10 = null;
                if (this.fos == null) throw throwable;
                try {
                    this.fos.close();
                    throw throwable;
                }
                catch (IOException ioex) {
                    this.errBuffer.append(ioex.getMessage()).append(Constants.s_LINE_SEP);
                    Logging.errorPrint("Exception in FOPHandler:run", ioex);
                }
                throw throwable;
            }
        }
        if (this.mode == 1) {
            this.renderer = FOPHandler.createAWTRenderer();
            this.driver.setRenderer(this.renderer);
            try {
                XMLReader parser = this.inputHandler.getParser();
                this.driver.render(parser, this.inputHandler.getInputSource());
                return;
            }
            catch (FOPException fopex) {
                this.errBuffer.append(fopex.getMessage()).append(Constants.s_LINE_SEP);
                Logging.errorPrint("Exception in FOPHandler:run", fopex);
            }
            return;
        } else {
            Logging.errorPrint("Unsupported mode for file export.");
        }
    }

    private static AWTRenderer createAWTRenderer() {
        byte[] bytes = new byte[]{};
        return new AWTRenderer((Translator)new SecureResourceBundle((InputStream)new ByteArrayInputStream(bytes)));
    }
}

