/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class FOPResourceChecker {
    private static int missingResourceCount;
    private static StringBuffer resourceBuffer;
    private static final String whereToGetIt = "<a href=\"http://prdownloads.sourceforge.net/pcgen/pdf_new.zip\">pdf.zip</a>";
    static final String getItHereMsg;
    static final String missingLibMsg;

    public static int getMissingResourceCount() {
        return missingResourceCount;
    }

    public static String getMissingResourceMessage() {
        if (missingResourceCount != 0) {
            return resourceBuffer.toString() + "\n" + getItHereMsg + whereToGetIt + "\n" + missingLibMsg;
        }
        return "";
    }

    public static boolean hasResource(String forName, String jarName, StringBuffer sb) {
        try {
            Class.forName(forName);
            return true;
        }
        catch (ClassNotFoundException cnfex) {
            sb.append("Missing resource: ").append(jarName).append('\n');
        }
        catch (NoClassDefFoundError ncdfer) {
            sb.append("Missing dependency of resource: ").append(jarName).append('\n');
            Logging.errorPrint("Error loading class " + forName + ": " + ncdfer.toString(), ncdfer);
        }
        return false;
    }

    private static void checkResource() {
        String[] resources = new String[]{"org.apache.fop.apps.Fop", "fop.jar", "org.apache.xalan.xslt.Process", "xalan-2.4.1.jar", "org.apache.batik.dom.svg.SVGDocumentFactory", "batik.jar"};
        for (int i = 0; i < resources.length / 2; ++i) {
            if (FOPResourceChecker.hasResource(resources[i * 2], resources[i * 2 + 1], resourceBuffer)) continue;
            ++missingResourceCount;
        }
        if (missingResourceCount > 0) {
            // empty if block
        }
    }

    static {
        getItHereMsg = PropertyFactory.getString("in_FollowLink");
        missingLibMsg = PropertyFactory.getString("MissingLibMessage").replace('|', '\n');
        missingResourceCount = 0;
        resourceBuffer = new StringBuffer(0);
        FOPResourceChecker.checkResource();
    }
}

