/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.awt.Toolkit;
import pcgen.util.PropertyFactory;

public class Logging {
    private static boolean debugMode = false;
    private static final Toolkit s_TOOLKIT = Toolkit.getDefaultToolkit();

    public static void setDebugMode(boolean argDebugMode) {
        debugMode = argDebugMode;
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void debugPrint(String s) {
        if (Logging.isDebugMode()) {
            System.out.println(s);
        }
    }

    public static void debugPrint(String param1, Object param2) {
        if (Logging.isDebugMode()) {
            System.out.println(param1 + param2);
        }
    }

    public static void debugPrintLocalised(String param1, Object param2) {
        if (Logging.isDebugMode()) {
            String msg = PropertyFactory.getFormattedString(param1, param2);
            System.out.println(msg);
        }
    }

    public static void debugPrintLocalised(String message, Object param1, Object param2) {
        if (Logging.isDebugMode()) {
            String msg = PropertyFactory.getFormattedString(message, param1, param2);
            System.out.println(msg);
        }
    }

    public static void debugPrint(String s, Throwable thr) {
        Logging.debugPrint(s);
    }

    public static void errorPrintLocalised(String s) {
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        String msg = PropertyFactory.getString(s);
        System.err.println(msg);
    }

    public static void errorPrintLocalised(String s, Object param1) {
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        String msg = PropertyFactory.getFormattedString(s, param1);
        System.err.println(msg);
    }

    public static void errorPrintLocalised(String s, Object param1, Object param2) {
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        String msg = PropertyFactory.getFormattedString(s, param1, param2);
        System.err.println(msg);
    }

    public static void errorPrint(String s) {
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        System.err.println(s);
    }

    public static void errorPrint(String s, Throwable thr) {
        Logging.errorPrint(s);
        thr.printStackTrace(System.err);
    }

    public static void errorPrintLocalised(String s, Throwable thr) {
        Logging.errorPrint(PropertyFactory.getString(s));
        thr.printStackTrace(System.err);
    }
}

