/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.util.Stack;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.PostfixMathCommandI;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;

public final class PJEP
extends JEP {
    private Object parent;
    private String variableSource;

    public PJEP() {
        this.setAllowUndeclared(true);
        this.addStandardFunctions();
        this.addFunction("ceil", (PostfixMathCommandI)new Ceil());
        this.addFunction("floor", (PostfixMathCommandI)new Floor());
        this.addFunction("max", (PostfixMathCommandI)new Max());
        this.addFunction("min", (PostfixMathCommandI)new Min());
        this.addFunction("getvar", (PostfixMathCommandI)new GetVar());
        this.addFunction("var", (PostfixMathCommandI)new GetVar());
        this.addFunction("if", (PostfixMathCommandI)new If());
        this.addFunction("CEIL", (PostfixMathCommandI)new Ceil());
        this.addFunction("FLOOR", (PostfixMathCommandI)new Floor());
        this.addFunction("MAX", (PostfixMathCommandI)new Max());
        this.addFunction("MIN", (PostfixMathCommandI)new Min());
        this.addFunction("GETVAR", (PostfixMathCommandI)new GetVar());
        this.addFunction("VAR", (PostfixMathCommandI)new GetVar());
        this.addFunction("IF", (PostfixMathCommandI)new If());
        this.addVariable("TRUE", 1.0);
        this.addVariable("FALSE", 0.0);
    }

    protected String getVariableSource() {
        return this.variableSource;
    }

    protected void setVariableSource(String variableSource) {
        this.variableSource = variableSource;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    private static final class If
    extends PostfixMathCommand {
        public If() {
            this.numberOfParameters = 3;
        }

        public void run(Stack stack) throws ParseException {
            if (null == stack) {
                throw new ParseException("Stack argument null");
            }
            Object result = null;
            boolean condition = false;
            Object param3 = stack.pop();
            Object param2 = stack.pop();
            Object param1 = stack.pop();
            if (param1 instanceof Number) {
                condition = ((Number)param1).doubleValue() != 0.0;
            } else if (param1 instanceof Boolean) {
                condition = (Boolean)param1;
            } else {
                throw new ParseException("Invalid parameter type for Parameter 1");
            }
            result = condition ? (Object)param2 : (Object)param3;
            stack.push(result);
        }
    }

    private static final class Min
    extends PostfixMathCommand {
        public Min() {
            this.numberOfParameters = -1;
        }

        public void run(Stack stack) throws ParseException {
            if (null == stack) {
                throw new ParseException("Stack argument null");
            }
            Object param = null;
            double result = 0.0;
            boolean first = true;
            for (int i = 0; i < this.curNumberOfParameters; ++i) {
                param = stack.pop();
                if (param instanceof Number) {
                    if (first || ((Number)param).doubleValue() < result) {
                        result = ((Number)param).doubleValue();
                    }
                } else {
                    throw new ParseException("Invalid parameter type");
                }
                first = false;
            }
            stack.push(new Double(result));
        }
    }

    private static final class Max
    extends PostfixMathCommand {
        public Max() {
            this.numberOfParameters = -1;
        }

        public void run(Stack stack) throws ParseException {
            if (null == stack) {
                throw new ParseException("Stack argument null");
            }
            Object param = null;
            double result = 0.0;
            boolean first = true;
            for (int i = 0; i < this.curNumberOfParameters; ++i) {
                param = stack.pop();
                if (param instanceof Number) {
                    if (first || ((Number)param).doubleValue() > result) {
                        result = ((Number)param).doubleValue();
                    }
                } else {
                    throw new ParseException("Invalid parameter type");
                }
                first = false;
            }
            stack.push(new Double(result));
        }
    }

    private final class GetVar
    extends PostfixMathCommand {
        private GetVar() {
            this.numberOfParameters = -1;
        }

        /*
         * WARNING - void declaration
         */
        public void run(Stack inStack) throws ParseException {
            void var2_3;
            Object param1;
            this.checkStack(inStack);
            Object param2 = null;
            if (this.curNumberOfParameters == 1) {
                param1 = inStack.pop();
            } else if (this.curNumberOfParameters == 2) {
                param2 = inStack.pop();
                param1 = inStack.pop();
                if (!(param2 instanceof Double)) {
                    throw new ParseException("Invalid parameter type");
                }
            } else {
                throw new ParseException("Invalid parameter count");
            }
            Object result = null;
            if (var2_3 instanceof String) {
                PlayerCharacter aPC;
                if (PJEP.this.parent instanceof PlayerCharacter) {
                    PlayerCharacter character = (PlayerCharacter)PJEP.this.parent;
                    result = this.getVariableForCharacter(character, var2_3);
                } else if (PJEP.this.parent instanceof Equipment) {
                    boolean bPrimary = true;
                    if (param2 != null) {
                        bPrimary = ((Double)param2).intValue() != 0;
                    }
                    result = ((Equipment)PJEP.this.parent).getVariableValue((String)var2_3, "", "", bPrimary, Globals.getCurrentPC());
                } else if (PJEP.this.parent == null && (aPC = Globals.getCurrentPC()) != null) {
                    result = this.getVariableForCharacter(aPC, var2_3);
                }
                if (result == null) {
                    throw new ParseException("Error retreiving variable:" + var2_3);
                }
            } else {
                throw new ParseException("Invalid parameter type");
            }
            inStack.push(result);
        }

        protected Object getVariableForCharacter(PlayerCharacter character, Object param1) {
            Object result = character.getVariable((String)param1, true, true, PJEP.this.getVariableSource(), "", false);
            if (result == null) {
                result = character.getInternalVariable(null, (String)param1, PJEP.this.getVariableSource());
                try {
                    result = new Float((String)result);
                }
                catch (NumberFormatException e) {
                    result = null;
                }
            }
            if (result == null) {
                String external = character.getExportVariable((String)param1);
                try {
                    result = new Float(external);
                }
                catch (NumberFormatException e) {
                    result = null;
                }
            }
            return result;
        }
    }

    private static final class Floor
    extends PostfixMathCommand {
        private Floor() {
            this.numberOfParameters = 1;
        }

        public void run(Stack inStack) throws ParseException {
            this.checkStack(inStack);
            Object param = inStack.pop();
            if (!(param instanceof Double)) {
                throw new ParseException("Invalid parameter type");
            }
            double r = Math.floor((Double)param);
            inStack.push(new Double(r));
        }
    }

    private static final class Ceil
    extends PostfixMathCommand {
        private Ceil() {
            this.numberOfParameters = 1;
        }

        public void run(Stack inStack) throws ParseException {
            this.checkStack(inStack);
            Object param = inStack.pop();
            if (!(param instanceof Double)) {
                throw new ParseException("Invalid parameter type");
            }
            double r = Math.ceil((Double)param);
            inStack.push(new Double(r));
        }
    }
}

